<?php

namespace Drupal\miniorange_2fa\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\user\Entity\User;
use Drupal\miniorange_2fa\MoAuthUtilities;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Drupal\Core\Url;

class PasswordAuthForm extends FormBase {

  public function getFormId() {
    return 'mo_auth_password_auth_form';
  }

  public function buildForm(array $form, FormStateInterface $form_state) {
    $utilities = new MoAuthUtilities();
    $session = $utilities->getSession();
    $moMfaSession = $session->get("mo_auth", null);

    if (is_null($moMfaSession) || !isset($moMfaSession['uid'])) {
      $session->remove('mo_auth');
      $this->messenger()->addError($this->t('Invalid session. Please login again.'));
      $form_state->setRedirect('user.login');
      return [];
    }

    $form['password'] = [
      '#type' => 'password',
      '#title' => $this->t('Password'),
      '#required' => TRUE,
      '#description' => $this->t('Enter your password to continue.'),
    ];

    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Login'),
    ];

    return $form;
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $utilities = new MoAuthUtilities();
    $session = $utilities->getSession();
    $moMfaSession = $session->get("mo_auth", null);
    $user_id = $moMfaSession['uid'];
    $password = $form_state->getValue('password');

    $user = User::load($user_id);
    $passwordHasher = \Drupal::service('password');

    if ($passwordHasher->check($password, $user->getPassword())) {
      $variables_and_values = ['mo_auth_redirect_user_after_login'];
      $mo_db_values = $utilities->miniOrange_set_get_configurations($variables_and_values, 'GET');
      
      $session->remove('mo_auth');
      user_login_finalize($user);
      $session->save();

      $destination = $moMfaSession['redirect_url'] ?? null;
      if (!empty($destination)) {
        $_GET['destination'] = $destination;
      } else {
        $url = isset($mo_db_values['mo_auth_redirect_user_after_login']) && !empty($mo_db_values['mo_auth_redirect_user_after_login']) 
          ? $mo_db_values['mo_auth_redirect_user_after_login'] 
          : Url::fromRoute('user.page')->toString();
        $response = new RedirectResponse($url);
        $response->send();
        exit;
      }
    } else {
      $this->messenger()->addError($this->t('Invalid password. Please try again.'));
      $form_state->setRebuild();
    }
  }
}

