<?php

namespace Drupal\miniorange_2fa\Helper\FormHelper;

use Drupal\Core\Form\FormStateInterface;
use Drupal\miniorange_2fa\MoAuthUtilities;
use Drupal\miniorange_2fa\MiniorangeCustomerProfile;
use Drupal\miniorange_2fa\UsersAPIHandler;
use Drupal\miniorange_2fa\MiniorangeUser;
use Drupal\miniorange_2fa\AuthenticationType;
use Drupal\miniorange_2fa\MoAuthConstants;
use Drupal\miniorange_2fa\Helper\FormHelper\MoAuthTitle;
use Drupal\Core\Url;
use Drupal\Core\Render\Markup;


class MoAuthCustomerSetupFormComponents
{
  public static function getPluginConfigurationForm($form, $form_state, $user_id)
  {
    $utilities = new MoAuthUtilities();
    $custom_attribute = $utilities::get_users_custom_attribute($user_id);
    $user_email = isset($custom_attribute[0]) && is_object($custom_attribute[0]) ? $custom_attribute[0]->miniorange_registered_email : '-';
    $customer = new MiniorangeCustomerProfile();
    $user_api_handler = new UsersAPIHandler($customer->getCustomerID(), $customer->getAPIKey());
    $miniorange_user = new MiniorangeUser($customer->getCustomerID(), $user_email, '', '', '');
    $response = $user_api_handler->get($miniorange_user);
    $authType = AuthenticationType::getAuthType(is_object($response) && $response->status != 'FAILED' ? $response->authType : '-');

    if (MoAuthUtilities::isWebAuthnExtensionInstalled() && MoAuthUtilities::isWebAuthnConfiguredForUser($user_id)) {
      $authType = AuthenticationType::getAuthType("WEB AUTHN");
    }

    $variables_and_values = array(
      'mo_user_limit_exceed',
      'mo_auth_customer_admin_email',
      'mo_auth_customer_id',
      'mo_auth_customer_api_key',
      'mo_auth_customer_token_key',
      'mo_auth_customer_app_secret',
      'mo_auth_2fa_license_type',
      'mo_auth_2fa_license_plan',
      'mo_auth_2fa_license_no_of_users',
      'mo_auth_2fa_ivr_remaining',
      'mo_auth_2fa_sms_remaining',
      'mo_auth_2fa_email_remaining',
      'mo_auth_2fa_license_expiry',
      'mo_auth_2fa_support_expiry',
    );
    $mo_db_values = $utilities->miniOrange_set_get_configurations($variables_and_values, 'GET');

    $title = [
      'name'        => t('Profile'),
      'description' => t('Thank you for being a part of the miniOrange Drupal family. Find your profile details here.'),
    ];
    MoAuthTitle::buildTitleForm($form, $form_state, $title);

    /** Show message if user creation limit exceeded */
    $mo_user_limit = $mo_db_values['mo_user_limit_exceed'];
    if (isset($mo_user_limit) && $mo_user_limit == TRUE) {
      $form['markup_top_2'] = array(
        '#markup' => '<div class="users_2fa_limit_exceeded_message">' . t('Your user creation limit has been completed. Please upgrade your license to add more users. Please ignore if already upgraded.') . ' </div>'
      );
    }

    $form['mo_profile_information'] = array(
      '#type' => 'details',
      '#title' => t('Profile Details'),
      '#attributes' => array('style' => 'margin-bottom:2%;'),
      //'#open' => TRUE,
    );

    $mo_table_content = array(
      array('2FA Registered Email', $mo_db_values['mo_auth_customer_admin_email']),
      array('Activated 2FA Method', isset($authType['name']) ? $authType['name'] : ''),
      array('Xecurify Registered Email', $user_email),
      array('Customer ID', $mo_db_values['mo_auth_customer_id']),
      array('Drupal Version', MoAuthUtilities::mo_get_drupal_core_version()),
      array('PHP Version', phpversion()),
    );

    $form['mo_profile_information']['miniorange_testing_form_element'] = array(
      '#type' => 'table',
      '#header' => array('ATTRIBUTE', 'VALUE'),
      '#rows' => $mo_table_content,
      '#empty' => t('Something is not right. Please run the update script or contact us at') . '<a href="mailto:drupalsupport@xecurify.com">drupalsupport@xecurify.com</a>',
      '#responsive' => TRUE,
      '#sticky' => FALSE, //headers will move with the scroll
      '#size' => 2,
    );

    $form['mo_profile_information']['miniorage_remove_account'] = array(
      '#type' => 'link',
      '#title' => t('Remove Account'),
      '#url' => Url::fromRoute('miniorange_2fa.modal_form'),
      '#attributes' => [
        'class' => [
          'use-ajax',
          'button',
        ],
      ]
    );

    $form['mo_license_information'] = array(
      '#type' => 'details',
      '#title' => t('License Info'),
      '#open' => true,
    );

    $isLicenseExpired = MoAuthUtilities::getIsLicenseExpired($mo_db_values['mo_auth_2fa_license_expiry']);

    $cron_run_interval = \Drupal::config('automated_cron.settings')->get('interval');
    $cron_run_interval = $cron_run_interval != 0 ? \Drupal::service('date.formatter')->formatInterval($cron_run_interval) : 'Never';
    $last_cron_run     = \Drupal::state()->get('system.cron_last');
    $last_cron_run     = \Drupal::service('date.formatter')->formatTimeDiffSince($last_cron_run);
    $cron_message      = MoAuthUtilities::getCronInformation();

    $NoofUsers = '';
    if (isset($mo_db_values['mo_auth_2fa_license_type']) && $mo_db_values['mo_auth_2fa_license_type'] == 'DRUPAL_2FA') {
      $NoofUsers = [
        'data' => Markup::create('</span><a class="js-form-submit form-submit use-ajax" href="requestDemo">Explore 2FA policies for End Users</a>')
      ];
    }

    if (isset($mo_db_values['mo_auth_2fa_license_type']) && $mo_db_values['mo_auth_2fa_license_type'] == MoAuthConstants::LICENSE_TYPE) {
      $NoofUsers = [
        'data' => Markup::create('</span><a class="js-form-submit form-submit use-ajax" href="contact_us">ADD MORE USERS</a>')
      ];
    }

    $updateLicense = '';
    if ($isLicenseExpired['LicenseGoingToExpire']) {
      $updateLicense = [
        'data' => Markup::create('</span><a class="js-form-submit form-submit use-ajax" href="contact_us">ADD MORE USERS</a>')
      ];
    }

    $mo_license_table_content = array(
      array('License Type', $mo_db_values['mo_auth_2fa_license_type'], ''),
      array('License Plan', $mo_db_values['mo_auth_2fa_license_plan'], ''),
      array('No. of Users', $mo_db_values['mo_auth_2fa_license_no_of_users'], $NoofUsers),
    );
    $mo_license_table_content_2 = array(
      array('IVR Transactions Remaining', $mo_db_values['mo_auth_2fa_ivr_remaining'], ''),
      array('SMS Transactions Remaining', $mo_db_values['mo_auth_2fa_sms_remaining'], ''),
      array('Email Transactions Remaining', $mo_db_values['mo_auth_2fa_email_remaining'], ''),
      array('License Expiry', $mo_db_values['mo_auth_2fa_license_expiry'], $updateLicense),
      array('Support Expiry', $mo_db_values['mo_auth_2fa_support_expiry'], ''),
      array('Cron Run Interval', $cron_message, ''),
    );


    if ($mo_db_values['mo_auth_2fa_license_type'] !== 'DRUPAL_2FA') {
      $mo_license_table_content = array_merge($mo_license_table_content, $mo_license_table_content_2);
    }

    $form['mo_license_information']['miniorange_hidden_value'] = array(
      '#type' => 'hidden',
      '#value' => 'User_Logged_in',
    );

    $form['mo_license_information']['miniorange_customer-license'] = array(
      '#type' => 'table',
      '#header' => array('ATTRIBUTE', 'VALUE', 'ACTION'),
      '#rows' => $mo_license_table_content,
      '#empty' => t('Something is not right. Please run the update script or contact us at') . ' <a href="mailto:drupalsupport@xecurify.com">drupalsupport@xecurify.com</a>',
      '#responsive' => TRUE,
      '#sticky' => FALSE, //headers will move with the scroll
      '#size' => 2,
      '#prefix' => '',
      '#suffix' => '<br>',
    );

    $form['mo_license_information']['fecth_customer_license'] = array(
      '#type' => 'submit',
      '#button_type' => 'primary',
      '#value' => t('Check License'),
      '#submit' => ['::fetchLicenseSubmit'],
    );

    $form['mo_license_information']['faq_link'] = [
           '#markup' => '<a target="_blank" href="' . MoAuthConstants::MO_FAQ_LINK . '"><em>' .
          t('Click here for FAQ\'s 🔗') . '</em></a>'
      ];


    if ($mo_db_values['mo_auth_2fa_license_type'] === 'DRUPAL_2FA') {
      $form['mo_license_information']['miniorage_request_demo'] = array(
        '#type' => 'link',
        '#title' => t('Request 7 Days Trial'),
        '#url' => Url::fromRoute('miniorange_2fa.request_demo'),
        '#attributes' => [
          'class' => [
            'use-ajax',
            'button',
          ],
        ],
      );
    }

    $form['mo_license_information']['markup_end'] = array(
      '#markup' => '</div>'
    );

    return $form;
  }


  public static function getLoginForm($form, $form_state, $url)
  {
    $form['mo_login_form'] = array(
      '#type' => 'fieldset',
      '#title' => t('Login with miniOrange account')
    );

    $form['mo_login_form']['Mo_auth_customer_login_username'] = array(
      '#type' => 'email',
      '#title' => t('Email'),
      '#attributes' => array('style' => 'width:29%'),
      '#required' => true,
      '#placeholder' => t('Enter your email'),
    );

    $form['mo_login_form']['Mo_auth_customer_login_password'] = array(
      '#type' => 'password',
      '#title' => t('Password'),
      '#attributes' => array('style' => 'width:29%'),
      '#required' => true,
      '#placeholder' => t('Enter your password'),
    );

    $form['mo_login_form']['Mo_auth_customer_login_button'] = array(
      '#type' => 'submit',
      '#value' => t('Login'),
      '#limit_validation_errors' => array(),
      '#prefix' => '<div class="ns_row"><div class="ns_name">',
      '#suffix' => '</div>',
      '#attributes' => [
        'class' => [
          'button',
          'button--primary',
        ],
      ],
    );

    $form['mo_login_form']['register_link'] = array(
      '#markup' => '<a href="https://www.miniorange.com/businessfreetrial" target="_blank" class="button">' . t('Create an account?') . '</a>',
      '#prefix' => '<div class="ns_value">',
      '#suffix' => '</div>'
    );

    $form['mo_login_form']['markup_end'] = array(
      '#markup' => '</div>'
    );

    return $form;
  }
}
