<?php

namespace Drupal\miniorange_2fa;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;

/**
 * Modifies the miniorange_2fa services based on available services.
 */
class Miniorange2faServiceProvider extends ServiceProviderBase {
//do not change name of the class, it is Drupal's convention to use ServiceProvider for service providers.
  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    // Check if the basic_auth service exists.
    if (!$container->has('basic_auth.authentication.basic_auth')) {
      // If the basic_auth service doesn't exist, remove our decorator.
      if ($container->hasDefinition('miniorange_2fa.basic_auth_decorator')) {
        $container->removeDefinition('miniorange_2fa.basic_auth_decorator');
      }
    }
  }
}
