<?php

namespace Drupal\miniorange_2fa\Plugin\AuthenticationType;

use Drupal\miniorange_2fa\Plugin\TotpAuthenticationTypePluginBase;
use Drupal\miniorange_2fa\Annotation\AuthenticationType;

/**
 * Generic Authenticator authentication type plugin.
 *
 * @AuthenticationType(
 *   id = "generic_authenticator",
 *   name = @Translation("Generic Authenticator"),
 *   code = "GENERIC AUTHENTICATOR",
 *   type = "TOTP",
 *   description = @Translation("Use any TOTP-compatible authenticator app to generate time-based one-time passwords."),
 *   supported_devices = {"mobile", "tablet"},
 *   challenge = true,
 *   oob = false,
 * )
 */
class GenericAuthenticatorType extends TotpAuthenticationTypePluginBase {

  /**
   * {@inheritdoc}
   */
  protected function shouldShowDownloadStep(): bool {
    return FALSE;
  }

} 