<?php

namespace Drupal\miniorange_2fa\Plugin\AuthenticationType;

use Drupal\miniorange_2fa\Plugin\TotpAuthenticationTypePluginBase;
use Drupal\miniorange_2fa\Annotation\AuthenticationType;

/**
 * Google Authenticator authentication type plugin.
 *
 * @AuthenticationType(
 *   id = "google_authenticator",
 *   name = @Translation("Google Authenticator"),
 *   code = "GOOGLE AUTHENTICATOR",
 *   type = "TOTP",
 *   description = @Translation("Use Google Authenticator app to generate time-based one-time passwords."),
 *   supported_devices = {"mobile", "tablet"},
 *   challenge = true,
 *   oob = false,
 *   ios_link = "https://itunes.apple.com/us/app/google-authenticator/id388497605?mt=8",
 *   android_link = "https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en"
 * )
 */
class GoogleAuthenticatorType extends TotpAuthenticationTypePluginBase {

  /**
   * {@inheritdoc}
   */
  protected function shouldShowDownloadStep(): bool {
    return TRUE;
  }
} 