<?php

namespace Drupal\miniorange_2fa\Plugin\AuthenticationType;

use Drupal\miniorange_2fa\Plugin\TotpAuthenticationTypePluginBase;
use Drupal\miniorange_2fa\Annotation\AuthenticationType;

/**
 * Microsoft Authenticator authentication type plugin.
 *
 * @AuthenticationType(
 *   id = "microsoft_authenticator",
 *   name = @Translation("Microsoft Authenticator"),
 *   code = "MICROSOFT AUTHENTICATOR",
 *   type = "TOTP",
 *   description = @Translation("Use Microsoft Authenticator app to generate time-based one-time passwords."),
 *   supported_devices = {"mobile", "tablet"},
 *   challenge = true,
 *   oob = false,
 *   ios_link = "https://itunes.apple.com/us/app/microsoft-authenticator/id983156458?mt=8",
 *   android_link = "https://play.google.com/store/apps/details?id=com.azure.authenticator&hl=en"
 * )
 */
class MicrosoftAuthenticatorType extends TotpAuthenticationTypePluginBase {

  /**
   * {@inheritdoc}
   */
  protected function shouldShowDownloadStep(): bool {
    return TRUE;
  }
} 