<?php

namespace Drupal\miniorange_2fa\Plugin\AuthenticationType;

use Drupal\miniorange_2fa\Plugin\QrBasedAuthenticationTypePluginBase;
use Drupal\miniorange_2fa\Annotation\AuthenticationType;

/**
 * miniOrange Authenticator authentication type plugin.
 *
 * @AuthenticationType(
 *   id = "miniorange_authenticator",
 *   name = @Translation("miniOrange Authenticator"),
 *   code = "SOFT TOKEN",
 *   type = "TOTP",
 *   description = @Translation("You have to enter passcode generated by miniOrange Authenticator App to login."),
 *   supported_devices = {"mobile", "tablet"},
 *   challenge = false,
 *   oob = false,
 *   ios_link = "https://apps.apple.com/app/id1482362759",
 *   android_link = "https://play.google.com/store/apps/details?id=com.miniorange.android.authenticator",
 *   doc_link = "https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-modules/setup-guides-to-configure-various-2fa-mfa-tfa-methods/totp-tfa-methods-authenticator-apps/setup-miniorange-authenticator-as-2fa-tfa-method",
 *   video_link = ""
 * )
 */
class MiniorangeAuthenticatorType extends QrBasedAuthenticationTypePluginBase {

} 