<?php

namespace Drupal\miniorange_2fa\Plugin\AuthenticationType;

use Drupal\miniorange_2fa\Annotation\AuthenticationType;
use Drupal\miniorange_2fa\Plugin\OtpAuthenticationTypePluginBase;

/**
 * @AuthenticationType(
 *   id = "otp-over-phone",
 *   name = "OTP Over PHONE",
 *   code = "PHONE VERIFICATION",
 *   type = "OTP",
 *   description = "You will receive an OTP (One Time Passcode) via phone call. You have to enter the OTP to authenticate yourself.",
 *   supported_devices = {"Feature Phones", "Smartphones"},
 *   challenge = true,
 *   oob = false
 * )
 */
class PhoneAuthenticationType extends OtpAuthenticationTypePluginBase {

  /**
   * {@inheritdoc}
   */
  protected function shouldRenderPhoneField(): bool {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  protected function addMethodSpecificWarnings(): void {
    $credits = $this->getRemainingCredits();
    $phone_remaining = $credits['mo_auth_2fa_ivr_remaining'] ?? 0;
   
    if ($phone_remaining == 0) {
      $this->addWarningMessage('Zero Phone Call Transactions Remaining');
    }
    elseif ($phone_remaining <= 10) {
      $this->addWarningMessage('Low Phone Call Transactions Remaining: @count calls left.', ['@count' => $phone_remaining]);
    }
  }
}
