<?php

namespace Drupal\miniorange_2fa\Plugin\AuthenticationType;

use Drupal\miniorange_2fa\Plugin\QrBasedAuthenticationTypePluginBase;
use Drupal\miniorange_2fa\Annotation\AuthenticationType;

/**
 * Push Notifications authentication type plugin.
 *
 * @AuthenticationType(
 *   id = "push_notifications",
 *   name = @Translation("Push Notifications"),
 *   code = "PUSH NOTIFICATIONS",
 *   type = "OTHER",
 *   description = @Translation("You will receive a push notification on your mobile device. You have to accept the notification to authenticate yourself."),
 *   supported_devices = {"mobile"},
 *   challenge = true,
 *   oob = true,
 *   ios_link = "https://apps.apple.com/app/id1482362759",
 *   android_link = "https://play.google.com/store/apps/details?id=com.miniorange.android.authenticator",
 *   doc_link = "https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-modules/setup-guides-to-configure-various-2fa-mfa-tfa-methods/push-notification-methods/setup-push-notifications-as-2fa-tfa-method",
 *   video_link = ""
 * )
 */
class PushNotificationsType extends QrBasedAuthenticationTypePluginBase {

} 