<?php

namespace Drupal\miniorange_2fa\Services;

use Drupal\Core\Database\Connection;
use Drupal\Core\Session\AccountInterface;

/**
 * Service for logging MFA/2FA events.
 */
class MfaLoggerService {

  /**
   * The database connection.
   *
   * @var \Drupal\Core\Database\Connection
   */
  protected $database;

  /**
   * Constructs the logger service.
   */
  public function __construct(Connection $database) {
    $this->database = $database;
  }

  /**
   * Logs an MFA/2FA event.
   *
   * @param \Drupal\Core\Session\AccountInterface $user
   *   The user account.
   * @param string $event_type
   *   Type of event (e.g., login_attempt, enable_mfa, disable_mfa).
   * @param string $status
   *   Status of the event (e.g., success, failure).
   */
  public function logEvent(AccountInterface $user, $event_type, $status,$message = '') {
    $this->database->insert('miniorange_2fa_logs')
      ->fields([
        'uid' => $user->id(),
        'username' => $user->getAccountName(),
        'event_type' => $event_type,
        'status' => $status,
        'timestamp' => \Drupal::time()->getCurrentTime(),
        'message' => $message 
      ])
      ->execute();
  }

}
