<?php

namespace Drupal\miniorange_oauth_client\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\FormBase;
use Drupal\miniorange_oauth_client\Utilities;
use Drupal\Core\Url;

class ConfirmDelete extends FormBase
{

  /**
   * {@inheritDoc}
   */
  public function getFormId()
  {
    return 'miniorange_oauth_client_configure_app';
  }

  /**
   * {@inheritDoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state)
  {

    $form['markup_library'] = [
      '#attached' => [
        'library' => [
          "miniorange_oauth_client/miniorange_oauth_client.oauth_config",
          "miniorange_oauth_client/miniorange_oauth_client.admin",
          "miniorange_oauth_client/miniorange_oauth_client.style_settings",
          "core/drupal.dialog.ajax",
        ],
      ],
    ];
    $action = \Drupal::request()->query->get('action');

    $client_app = \Drupal::config('miniorange_oauth_client.settings')->get('miniorange_oauth_client_app');

    $form['confirm_fieldset'] = [
      '#type' => 'fieldset'
    ];

    $message = $this->t('Are you sure you want to @action the configuration for @app?', ['@action' => $action, '@app' => $client_app]);

    $form['confirm_fieldset']['message'] = [
      '#markup' => $message,
      '#suffix' => '<br>',
    ];

    $form['confirm_fieldset']['submit'] = [
      '#type' => 'submit',
      '#value' => $action === 'delete' ? $this->t('Delete') : $this->t('Reset'),
      '#submit' => ['::resetConfig'],
      '#attributes' => ['class' => ['button', 'button--primary']],
    ];

    $form['confirm_fieldset']['cancel'] = [
      '#type' => 'link',
      '#title' => $this->t('Cancel'),
      '#url' => Url::fromRoute('miniorange_oauth_client.config_clc')->setOption('query', ['app_name' => $client_app] + ($action === 'delete' ? [] : ['action' => 'update'])),
      '#attributes' => [
        'class' => ['button', 'cancel-button'],
      ],
    ];

    Utilities::moOAuthShowCustomerSupportIcon($form, $form_state);
    return $form;
  }

  /**
   * {@inheritDoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {}

  public function resetConfig(array &$form, FormStateInterface $form_state) {

    $base_url = \Drupal::request()->getSchemeAndHttpHost().\Drupal::request()->getBasePath();
    $baseUrlValue = Utilities::getOauthBaseURL($base_url);
    $config = \Drupal::configFactory()->getEditable('miniorange_oauth_client.settings');
    $config ->set('miniorange_oauth_enable_login_with_oauth',1)
      ->clear('miniorange_oauth_client_app')
      ->clear('miniorange_oauth_client_appval')
      ->clear('miniorange_auth_client_app_name')
      ->set('miniorange_auth_client_display_name', 'Log in using ##app_name##')
      ->clear('miniorange_auth_client_client_id')
      ->clear('miniorange_auth_client_client_secret')
      ->clear('miniorange_auth_client_scope')
      ->clear('miniorange_auth_client_authorize_endpoint')
      ->clear('miniorange_auth_client_access_token_ep')
      ->clear('miniorange_auth_client_user_info_ep')
      ->clear('miniorange_auth_client_stat')
      ->clear('miniorange_auth_client_callback_uri')
      ->clear('miniorange_oauth_client_credentials_location')
      ->clear('miniorange_oauth_client_attr_list_from_server')
      ->clear('miniorange_oauth_client_base_url')
      ->clear('miniorange_oauth_client_enable_logging')
      ->clear('miniorange_oauth_client_email_attr_val')
      ->clear('miniorange_oauth_client_name_attr_val')
      ->clear('miniorange_oauth_client_other_field_for_name')
      ->clear('miniorange_oauth_client_other_field_for_email')
      ->clear('miniorange_oauth_client_attr_list_from_server_for_dropdown')
      ->set('miniorange_oauth_send_with_body_oauth', 1)
      ->set('miniorange_auth_client_callback_uri', $baseUrlValue . "/mo_login")
      ->save();

    $this->messenger()->addMessage($this->t('Your Configuration have been deleted successfully.'));
    $form_state->setRedirect('miniorange_oauth_client.config_clc');

  }

}
