(function ($, Drupal) {
  Drupal.behaviors.copyIcon = {
    attach: function (context, settings) {
      $('.mo-copy-icon-span', context)
        .off('click.copyIcon')
        .on('click.copyIcon', function () {
          const $wrapper = $(this);
          const $icon = $wrapper.find('.mo-copy-icon');
          const targetId = $wrapper.data('target');
          const input = document.getElementById(targetId);

          if (input) {
            const value = input.value.trim();

            // Remove any existing message
            $wrapper.find('.mo-copy-msg').remove();

            if (value) {
              navigator.clipboard.writeText(value).then(() => {
                const $msg = $('<span>Copied!</span>');
                $icon.after($msg);
                setTimeout(() => $msg.fadeOut(300, () => $msg.remove()), 1000);
              });
            } else {
              // Show "No data to copy"
              const $msg = $('<span>No data to copy!</span>');
              $icon.after($msg);
              setTimeout(() => $msg.fadeOut(300, () => $msg.remove()), 1500);
            }
          }
        });
    }
  };
})(jQuery, Drupal);
