<?php

declare(strict_types=1);

namespace Drupal\miniorange_oauth_client\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;


/**
 * Defines the miniOrange role mapping entity type.
 *
 * @ConfigEntityType(
 *   id = "mo_role_mapping",
 *   label = @Translation("MiniOrange Role Mapping Entity"),
 *   label_collection = @Translation("MiniOrange Role Mapping Entities"),
 *   label_singular = @Translation("miniorange role mapping entity"),
 *   label_plural = @Translation("miniorange role mapping entities"),
 *   label_count = @PluralTranslation(
 *     singular = "@count miniorange role mapping entity",
 *     plural = "@count miniorange role mapping entities",
 *   ),
 *   handlers = {
 *     "form" = {
 *       "edit" = "Drupal\miniorange_oauth_client\Form\MoRoleMappingForm",
 *     },
 *   },
 *   config_prefix = "mo_role_mapping",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "id",
 *   },
 *   config_export = {
 *     "id",
 *     "enable_role_mapping",
 *     "disable_role_update",
 *     "default_role",
 *     "role_attribute",
 *     "custom_roles",
 *   },
 * )
 */
final class MoRoleMapping extends ConfigEntityBase {

  protected ?string $id;
  protected ?bool $enable_role_mapping = false;
  protected ?bool $disable_role_update = false;
  protected ?string $default_role = '';
  protected ?string $role_attribute = '';
  protected ?array $custom_roles = [];

  public function getId(): ?string
  {
    return $this->id;
  }
  public function setId(?string $id): MoRoleMapping
  {
    $this->id = $id;
    return $this;
  }

  public function getLabel() : ?string
  {
    return $this->label;
  }

  public function setLabel(?string $label) : MoRoleMapping
  {
    $this->label = $label;
    return $this;
  }
  public function getEnableRoleMapping(): ?bool
  {
    return $this->enable_role_mapping;
  }
  public function setEnableRoleMapping(?bool $enable_role_mapping): MoRoleMapping
  {
    $this->enable_role_mapping = $enable_role_mapping;
    return $this;
  }
  public function getDisableRoleUpdate() : ?bool
  {
    return $this->disable_role_update;
  }
  public function setDisableRoleUpdate(?bool $disable_role_update): MoRoleMapping
  {
    $this->disable_role_update = $disable_role_update;
    return $this;
  }
  public function getDefaultRole() : ?string
  {
    return $this->default_role;
  }
  public function setDefaultRole(?string $default_role): MoRoleMapping
  {
    $this->default_role = $default_role;
    return $this;
  }
  public function getRoleAttribute() : ?string
  {
    return $this->role_attribute;
  }
  public function setRoleAttribute(?string $role_attribute): MoRoleMapping
  {
    $this->role_attribute = $role_attribute;
    return $this;
  }
  public function getCustomRoles(): array
  {
    return $this->custom_roles;
  }
  public function setCustomRoles(?array $custom_roles): MoRoleMapping
  {
    $this->custom_roles = $custom_roles;
    return $this;
  }

  public static function readMe(string $id): self
  {
    return self::load($id) ?? self::create(['id' => $id]);
  }

}
