<?php

declare(strict_types=1);

namespace Drupal\miniorange_oauth_client\EventSubscriber;

use Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoUnoModuleSettingsSubscriber;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 *
 * @todo need to bring the ghost invoker component inside this part to perform operations dynamically.
 * @todo Add description for this subscriber.
 */
final class MoModuleSettingsSubscriber implements EventSubscriberInterface {
  use MoGhostInvoker;
  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      KernelEvents::REQUEST => ['onKernelRequest']
    ];
  }

  public function onKernelRequest(RequestEvent $event): void {
    $this->call([MoUnoModuleSettingsSubscriber::class, 'onKernelRequest'], ['event' => $event]);
  }
}
