<?php

namespace Drupal\miniorange_oauth_client\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\miniorange_oauth_client\Entity\MoLoginReport;

class MoLoginReportMultipleDeleteForm extends ConfirmFormBase
{
  /**
   * @inheritDoc
   */
  public function getQuestion()
  {
    return $this->t('Are you sure you want to clear login reports?');
  }

  public function getDescription()
  {
    return "";
  }

  /**
   * @inheritDoc
   */
  public function getCancelUrl()
  {
    return Url::fromRoute('entity.mo_login_reports.collection')->toString();
  }

  public function getConfirmText()
  {
    return $this->t('Proceed');
  }

  public function getCancelText()
  {
    return $this->t('Cancel');
  }

  public function submitForm(array &$form, FormStateInterface $form_state)
  {
    \Drupal::entityTypeManager()->getStorage('mo_login_reports')->delete(MoLoginReport::loadMultiple());
    $form_state->setRedirect('entity.mo_login_reports.collection');
  }

  public function getFormId()
  {
    return 'mo_login_report_multiple_delete_form';
  }
}
