<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoClientConfiguration\MoGrant;

use Drupal\Core\Url;
use Drupal\miniorange_oauth_client\Entity\MoClientConfiguration;
use Drupal\miniorange_oauth_client\MoHelper\MoUtilities;

abstract class MoUnoGrantsAbstract
{
  protected ?string $authentication_method;
  protected ?string $client_secret;
  protected ?string $client_id;
  protected ?string $token_endpoint;
  protected ?string $callback_url = null;
  protected ?string $grant_type;

  /**
   * Parent method to add Authentication methods to the grant types so this helps to build the options
   * based on the grant type if you need to add some additional options to it extend it in you child class and
   * overwrite the method
   *
   * @param array $options the base options for mapping the authorization grant methods
   *
   * @return void
   */
  public function getAuthenticationMethodOptions(array &$options): void
  {
    $options['values_in_header'] = 'Authorization Header';
    $options['values_in_body'] = 'Request Body';
  }

  public function readConfigCredentials(MoClientConfiguration $client_config) {
    $this->token_endpoint = $client_config->getAccessTokenEndpoint();
    $this->client_id = $client_config->getClientId();
    $this->client_secret = $client_config->getClientSecret();
    $this->authentication_method = $client_config->getAuthenticationMethod();
    $this->grant_type = $client_config->getGrantType();
    if ($this->grant_type !== 'password') {
      $this->callback_url = MoUtilities::getCallBackUrl($client_config->id());
    }
  }

  public function addCredentialsInRequest(array &$url_params = [], array &$headers = []): void
  {
    if ($this->authentication_method == 'values_in_header') {
      $headers['Authorization'] = 'Basic ' . base64_encode($this->client_id . ":" . $this->client_secret);
    } else{
      $url_params['client_id'] = $this->client_id;
      if ($this->authentication_method !== 'none' && !empty($this->client_secret)) {
        $url_params['client_secret'] = $this->client_secret;
      }
    }
  }

  public function validateCode(?string $code = '', ?array $query_params = [])
  {
    if (empty($code)) {
      throw new \Exception(
        'The Code returned from the provider is empty. <pre><code>' . print_r($query_params, true) . '<pre><code>'
      );
    }
  }
}
