<?php
/**
 * Provides subscription based functions for the module
 *
 * This class has list of functions that for validating the subscriptions stored in the database
 *
 * @author miniOrange
 * @version 1.0
 */
namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoLicense\MoLibrary;

use Drupal\miniorange_oauth_client\MoConstant\MoModuleConstant;
use Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoUnoLicenseTierManager;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;
use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoLicense\MoLibrary\MoStdSubscriptionLibrary as MoStandardSubscriptionLibrary;

class MoUnoSubscriptionLibrary {
use MoGhostInvoker;

  /**
   * Usage is to get the Module status
   *
   * @param array $form form elements
   *
   * @return bool
   * @throws \Exception
   */
  public function getModuleStatus(array &$form = []): bool
  {
    return
      $this->call([MoStandardSubscriptionLibrary::class, 'getModuleStatus'], ['form' => &$form]) ??
      $this->call([MoUnoLicenseTierManager::class, 'getLicenseVersion']) !== MoModuleConstant::MO_FREE_VERSION ??
      false;
  }

  /**
   * Get module expiration status
   *
   * @return void
   * @throws \Exception
   */
  public function checkModuleExpiry(): void
  {
    $this->call([MoStandardSubscriptionLibrary::class, 'checkModuleExpiry']);
  }

  /**
   * This function is to Validate the module to confirm its activation
   *
   * @throws \Exception
   */
  public function validateModule(): void
  {
    $this->call([MoStandardSubscriptionLibrary::class, 'validateModule']);
  }

  /**
   * This function helps in removing the license from the module.
   * 1) Remove the license from the MiniOrange server.
   * 2) Remove the configuration data from the module.
   *
   * @return void no need to return anything from the function
   *
   * @throws \Exception
   */
  public function removeModuleLicense(): void
  {
    $this->call([MoStandardSubscriptionLibrary::class, 'removeModuleLicense']);
  }

  /**
   * @throws \Exception
   */
  public function showModuleExpiryError(): void
  {
    $this->call([MoStandardSubscriptionLibrary::class, 'showModuleExpiryError']);
  }
}
