<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoOperations;

use Drupal\Core\Form\FormStateInterface;
use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoOperations\MoStdModuleSettings;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;

class MoUnoModuleSettings
{
  use MoGhostInvoker;

  /**
   * @throws \Exception
   */
  public function storeTokenInSessionAndCookie(?array $user_token): void
  {
    $this->call([MoStdModuleSettings::class, 'storeTokenInSessionAndCookie'], ['user_token' => $user_token]);
  }

  /**
   * @throws \Exception
   */
  public function modifyUserEditForm(array &$form, FormStateInterface $form_state): void
  {
    $this->call([MoStdModuleSettings::class, 'modifyUserEditForm'], ['form' => &$form, 'form_state' => $form_state]);
  }
}
