<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoOperations;

use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoOperations\MoStdUserManagement;
use Drupal\miniorange_oauth_client\MoDTO\MoModuleSettings;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;
use Drupal\user\Entity\User;

class MoUnoUserManagement
{

  use MoGhostInvoker;

  public function checkUserExists(?string $email)
  {
    !empty($email) || throw new \Exception("User Email is not provided.");
    return user_load_by_mail($email);
  }

  /**
   * @throws \Exception
   */
  public function createUser(?string $email, ?array $resource_owner, ?string $client_id): ?User
  {
    return $this->call(
      [MoStdUserManagement::class, 'createUser'],
      ['email' => $email, 'resource_owner' => $resource_owner, 'client_id' => $client_id]
    );
  }

  /**
   * @throws \Exception
   */
  public function getUserName(string $email, array $resource_owner, string $name_attribute = ''): ?string
  {
    return $this->call(
      [MoStdUserManagement::class, 'getUserName'],
      [
        'email' => $email,
        'resource_owner' => $resource_owner,
        'name_attribute' => $name_attribute
      ]
    );
  }

  /**
   * @throws \Exception
   */
  public function updateUserStatusOnSSO(User &$user): void
  {
    $this->call([MoStdUserManagement::class, 'updateUserStatusOnSSO'], ['user' => &$user]);
  }

  /**
   * @throws \Exception
   */
  public function checkDomainRestriction(string $email): void
  {
    $this->call([MoStdUserManagement::class, 'checkDomainRestriction'], ['email' => $email]);
  }

  /**
   * @throws \Exception
   */
  public function forceUpdateUserProfileAttributesOnSSO(User $user, bool $status = false): void
  {
    $this->call([MoStdUserManagement::class, 'forceUpdateUserProfileAttributesOnSSO'], ['user' => $user, 'status' => $status]);
  }
}
