<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures;

use Drupal\Core\Form\FormStateInterface;
use Drupal\miniorange_oauth_client\Entity\MoClientConfiguration;
use Drupal\miniorange_oauth_client\MoHelper\MoUtilities;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;

class MoUnoTestConfigAttributeListBuilder
{
  use MoGhostInvoker;
  public function buildTestConfigurationFrame(array &$result, ?string $entity_id): void
  {
    $entity = MoClientConfiguration::load($entity_id);
    if (empty($entity?->getServerTestAttributes())) {
      return;
    }
    $sub_lib = \Drupal::service('miniorange_oauth_client.uno_module_subscription_library');
    $disabled = $sub_lib->getModuleStatus();

    $frame['test_attribute_frame_is_enable'] = [
      '#type' => 'hidden',
      '#value' => (int)!$disabled
    ];

    $frame += [
      'test_attribute_frame' => [
        '#type' => 'details',
        '#open' => TRUE,
        '#title' => t('Test Configuration Attributes'),
        '#description' => t('The below are the list of attributes that are received from the IDP after performing the test configuration.'),
        'test_attributes' => [
          '#type' => 'table',
          '#header' => [
            'server_attr' => t('Server Attribute'),
            'value' => t('Value'),
          ],
          '#empty' => 'No Attributes found..',
        ]
      ]
    ];

    foreach (MoUtilities::normalizeRecursive($entity->getServerTestAttributes()) as $key => $val) {
      $frame['test_attribute_frame']['test_attributes'][] = [
        'server_attr' => ['#markup' => $key],
        'value' => ['#markup' => '<div class="mo-word-break">'. htmlspecialchars(is_array($val) ? json_encode($val) : $val) .'</div>'],
      ];
    }

    $frame['test_attribute_frame']['clear_button'] = [
      '#type' => 'submit',
      '#client_config_id' => $entity->id(),
      '#value' => t('Clear Attributes'),
      '#button_type' => 'danger',
      '#submit' => [[$this, 'clearTestConfigAttributes']],
      '#states' => [
        'disabled' => [
          [':input[name="test_attribute_frame_is_enable"]' => ['value' => '0']],
        ],
      ]
    ];
    $result += $frame;
  }

  /**
   * @throws \Exception
   */
  public function clearTestConfigAttributes(array $form, FormStateInterface $form_state): void
  {
    if (!empty($client = $form_state->getTriggeringElement()['#client_config_id'])) {
      $this->call([MoClientConfiguration::class, 'removeTestConfigAttributes'], ['config_id' => $client]);
    }
  }
}
