<?php

declare(strict_types=1);

namespace Drupal\miniorange_oauth_client\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the miniOrange profile mapping entity  type.
 *
 * @ConfigEntityType(
 *   id = "mo_profile_mapping",
 *   label = @Translation("miniOrange Profile Mapping Entity"),
 *   label_collection = @Translation("miniOrange Profile Mapping Entities"),
 *   label_singular = @Translation("miniOrange Profile Mapping Entity"),
 *   label_plural = @Translation("miniOrange Profile Mapping Entities"),
 *   label_count = @PluralTranslation(
 *     singular = "@count miniOrange Profile Mapping Entity",
 *     plural = "@count miniOrange Profile Mapping Entities",
 *   ),
 *   handlers = {
 *     "list_builder" = "Drupal\miniorange_oauth_client\MoProfileMappingListBuilder",
 *     "form" = {
 *       "edit" = "Drupal\miniorange_oauth_client\Form\MoProfileMappingForm",
 *     },
 *   },
 *   config_prefix = "mo_profile_mapping",
 *   admin_permission = "administer mo_profile_mapping",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "id",
 *   },
 *   config_export = {
 *     "id",
 *     "enable_profile_mapping",
 *     "profile_entity_type",
 *     "mapped_fields",
 *   },
 * )
 */
final class MoProfileMapping extends ConfigEntityBase
{

  protected string $id;
  protected ?bool $enable_profile_mapping = false;
  protected ?string $profile_entity_type = '';
  protected ?array $mapped_fields = [];

  public function getId(): string
  {
    return $this->id;
  }

  public function setId(string $id): MoProfileMapping
  {
    $this->id = $id;
    return $this;
  }

  public function getEnableProfileMapping(): bool
  {
    return $this->enable_profile_mapping;
  }

  public function setEnableProfileMapping(bool $enable_profile_mapping): MoProfileMapping
  {
    $this->enable_profile_mapping = $enable_profile_mapping;
    return $this;
  }

  public function getProfileEntityType(): string
  {
    return $this->profile_entity_type;
  }

  public function setProfileEntityType(string $profile_entity_type): MoProfileMapping
  {
    $this->profile_entity_type = $profile_entity_type;
    return $this;
  }

  public function getMappedFields(): ?array
  {
    return $this->mapped_fields;
  }

  public function setMappedFields(?array $mapped_fields): MoProfileMapping
  {
    $this->mapped_fields = $mapped_fields;
    return $this;
  }

  public static function readMe(string $id): self
  {
    return self::load($id) ?? self::create(['id' => $id]);
  }
}
