<?php

declare(strict_types=1);

namespace Drupal\miniorange_oauth_client\Entity;

use Drupal\Component\Plugin\Exception\InvalidPluginDefinitionException;
use Drupal\Component\Plugin\Exception\PluginNotFoundException;
use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityChangedTrait;
use Drupal\Core\Entity\EntityStorageException;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;

/**
 * Defines the mo_user_profile_attributes_sso entity class.
 *
 * @ContentEntityType(
 *   id = "mo_user_profile_attributes_sso",
 *   label = @Translation("mo_user_profile_attributes_sso"),
 *   label_collection = @Translation("mo_user_profile_attributes_ssos"),
 *   label_singular = @Translation("mo_user_profile_attributes_sso"),
 *   label_plural = @Translation("mo_user_profile_attributes_ssos"),
 *   label_count = @PluralTranslation(
 *     singular = "@count mo_user_profile_attributes_ssos",
 *     plural = "@count mo_user_profile_attributes_ssos",
 *   ),
 *   handlers = {
 *     "list_builder" = "Drupal\miniorange_oauth_client\MoUserProfileAttributesSSOEntityListBuilder",
 *     "views_data" = "Drupal\views\EntityViewsData",
 *   },
 *   base_table = "mo_user_profile_attributes_sso",
 *   admin_permission = "mo_administrator",
 *   entity_keys = {
 *     "id" = "id",
 *   },
 * )
 */
final class MoUserProfileAttributesSSOEntity extends ContentEntityBase {

  use EntityChangedTrait;

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type): array {

    $fields = parent::baseFieldDefinitions($entity_type);

    $fields['email'] = BaseFieldDefinition::create('email')
      ->setLabel(t('Email'))
      ->setDescription(t('The email address of the user.'));

    $fields['user_profile_attributes_updated'] = BaseFieldDefinition::create('boolean')
      ->setLabel(t('User Profile Attributes Updated'))
      ->setDefaultValue(FALSE)
      ->setDescription(t('The email address of the user.'));

    return $fields;
  }

  public static function readOrCreateByEmail(String $email)
  {
    $property = self::loadByProperty(['email' => $email]);
    return $property ?? self::create(['email' => $email]);
  }

  public static function getCurrentEntityTypeId(): string
  {
    return 'mo_user_profile_attributes_sso';
  }

  /**
   * Load entity by data
   *
   * @throws InvalidPluginDefinitionException
   * @throws PluginNotFoundException
   */
  public static function loadByProperty(array $data) : ?self {
    $entity = \Drupal::entityTypeManager()->getStorage(self::getCurrentEntityTypeId())->loadByProperties($data);
    return !empty($entity) ? reset($entity) : NULL;
  }

  /**
   *
   * Remove data by email
   *
   * @throws EntityStorageException
   * @throws InvalidPluginDefinitionException
   * @throws PluginNotFoundException
   */
  public static function removeByEmail(?string $email): void
  {
    $property = self::loadByProperty(['email' => $email]);
    $property?->delete();
  }
}
