<?php

namespace Drupal\miniorange_oauth_client\EventSubscriber;

use Drupal\Core\Url;
use Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoLicense\EventSubscriber\MoUnoLicenseSubscriber;
use Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoUnoLicenseTierManager;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\KernelEvents;

class MoLicenseSubscriber implements EventSubscriberInterface
{
  use MoGhostInvoker;
  public static function getSubscribedEvents() {
    return [
      KernelEvents::REQUEST => ['onKernelRequest', 1],
      KernelEvents::TERMINATE => ['onTerminate', 10],
    ];
  }

  /**
   * This function will execute after the response is sent to the user,
   *  once after the response is terminated it will get executed at the priority of 10.
   *
   * @return void no return values
   * @throws \Exception
   */
  public function onTerminate(): void
  {
    $this->call([MoUnoLicenseSubscriber::class, 'onTerminate']);
  }

  /**
   * This function is to display the license expiry to the administrators.
   * This also handles the direct route access of authorization and callback based on license status.
   *
   * @param RequestEvent $event
   *
   * @return void
   * @throws \Exception
   */
  public function onKernelRequest(RequestEvent $event): void
  {
    if (in_array($event->getRequest()->get('_route'), $this->routeList())) {
      $this->call([MoUnoLicenseSubscriber::class, 'onKernelRequest']);
    }
    if (in_array($event->getRequest()->get('_route'), ['mo_oauth.authorization_request', 'mo_oauth.authorization_response'])) {
      if (\Drupal::service('miniorange_oauth_client.uno_module_subscription_library')->getModuleStatus()) {
        $event->setResponse(new RedirectResponse(Url::fromRoute('user.login')->toString()));
      }
    }
  }

  /**
   * This route helps in fetching the routes where we can perform license validation to display license expiry error
   *
   * @throws \Exception
   */
  public function routeList(): array
  {
    return $this->call([MoUnoLicenseSubscriber::class, 'routeList']) ?? [];
  }
}

