<?php

declare(strict_types=1);

namespace Drupal\miniorange_oauth_client\Form;

use Drupal\Component\Utility\Html;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\miniorange_oauth_client\MoHelper\MoUtilities;
use Drupal\miniorange_oauth_client\MoService\MoLayoutBuilder;

/**
 * Provides a MiniOrange OAuth Client form.
 */
final class MoPasswordGrantTestConfigForm extends FormBase {
  use MoLayoutBuilder;
  private string $app_name;

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'mo_password_grant_test_config';
  }

  /**
   * {@inheritdoc}
   * @throws \Exception
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $request = \Drupal::request();
    $params = $request->query->all();
    $this->app_name = Html::escape($params['mo_client_config'] ?? null);

    !empty($this->app_name) || throw new \Exception("Configuration name is missing.");

    $form['login_heading'] = array(
      '#markup' => '<h4>'.t('Enter Your ').$this->app_name.t(' Credentials').'</h4>',
    );

    $form['username'] = array(
      '#type' => 'textfield',
      '#title' => t('Username'),
      '#required' => true,
      '#attributes' => ['placeholder' => 'Enter your '.$this->app_name.' username'],
    );

    $form['password'] = array(
      '#type' => 'password',
      '#title' => t('Password'),
      '#required' => true,
      '#attributes' => ['placeholder' => 'Enter your '.$this->app_name.' password'],
    );

    $form['test_connection'] = array(
      '#type' => 'submit',
      '#value' => t('Test Connection'),
      '#attributes' => ['class' =>['button','button--primary']],
    );
    return $this->buildMOLayout($form);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $username = $form_state->getValue('username');
    $password = $form_state->getValue('password');
    $form_state->setRedirect(
        'mo_oauth.authorization_request',
        ['mo_client_config' => $this->app_name],
        [
          'query' => [
            'user_data' => MoUtilities::encryptData(json_encode(['username' => $username, 'password' => $password]), '0000'),
            'test_sso' => true
          ],
        ]
    );
  }

}
