<?php
/**
 * This is a base file need to be updated with endpoints and primary details
 *
 * This class helps in defining all the constants used in this subscription library.
 * This helps in using it in various modules just by updating the constants in this file
 *
 * @author miniOrange
 * @version 1.0
 */
namespace Drupal\miniorange_oauth_client\MoConstant;

class MoModuleConstant
{
  // Basic Module Constants
  public const MODULE_NAME      = 'miniorange_oauth_client';
  public const CONFIG_NAME      = self::MODULE_NAME . '.settings';
  public const MODULE_NAME_TXT  = 'miniOrange OAuth Client';
  public const SUPPORT_EMAIL    = 'drupalsupport@xecurify.com';
  public const MODULE_SETTINGS  = self::CONFIG_NAME . '.module_settings';


  // Module route constants
  public const CONFIG_PAGE_URL     = 'mo_license.customer_config';
  const FETCH_LICENSE_ROUTE        = 'mo_license.fetch_license';
  const REMOVE_LICENSE_ROUTE       = 'mo_license.remove_license';
  const CUSTOMER_SUPPORT_URL       = 'mo_oauth.customer_support';


  // MiniOrange Login routes
  public const LICENSE_SERVER_BASE_URL = 'https://login.xecurify.com';

  // module video tutorial
  public const bool SHOW_VIDEO_TUTORIAL = false;

  // Constant FAQ
  public const MO_FAQ_LINK  = 'https://faq.miniorange.com/kb/drupal/drupal-oauth-oidc-sso/';

  // Landing page features section
  public const MO_Landing_PAGE_FEATURES = 'https://plugins.miniorange.com/drupal-sso-oauth-openid-single-sign-on#features';
  public const MO_Landing_PAGE_PRICING = 'https://plugins.miniorange.com/drupal-sso-oauth-openid-single-sign-on#pricing';

  //Constant GoogleScriptEndpoint
  public const string GOOGLE_SCRIPT_ENDPOINT = 'https://script.google.com/macros/s/AKfycbz7ArjWGK72rdA384_Wq3fdZ5acAlxFaeZg3lEZi8WNin9L-_r8oNjZfSiXLON078eB4Q/exec';

  // error messages
  public const COMMON_ERROR = "Something went wrong while processing your request. Please try again.";


  // Module Version Tier
  const float MO_UNO_MODULE_VERSION = 10.9;
  const float MO_STANDARD_MODULE_VERSION = 20.9;
  const float MO_PREMIUM_MODULE_VERSION = 30.9;
  const float MO_ENTERPRISE_MODULE_VERSION = 40.9;
  public const MO_FREE_VERSION = 'Uno';
  public const MO_STANDARD_VERSION = 'Standard';
  public const MO_PREMIUM_VERSION = 'Premium';
  public const MO_ENTERPRISE_VERSION = 'Enterprise';
  public const MO_FREE_VERSION_TIER = [self::MO_FREE_VERSION, self::MO_STANDARD_VERSION, self::MO_PREMIUM_VERSION, self::MO_ENTERPRISE_VERSION];
  public const MO_STANDARD_VERSION_TIER = [self::MO_STANDARD_VERSION, self::MO_PREMIUM_VERSION, self::MO_ENTERPRISE_VERSION];
  public const MO_PREMIUM_VERSION_TIER = [self::MO_PREMIUM_VERSION, self::MO_ENTERPRISE_VERSION];
  public const MO_ENTERPRISE_VERSION_TIER = [self::MO_ENTERPRISE_VERSION];
  public const MO_FREE_PLAN_NAME = 'drupal8_oauth_client_free_plan';
  public const MO_STANDARD_PLAN_NAME = 'drupal8_oauth_client_standard_plan';
  public const MO_PREMIUM_PLAN_NAME = 'drupal8_oauth_client_premium_plan';
  public const MO_ENTERPRISE_PLAN_NAME = 'drupal8_oauth_client_enterprise_plan';
  // Module success redirect priority builder
  public const int ATTRIBUTE_RESTRICTION_REDIRECT = 10;
  public const int BLOCKED_USER_REDIRECT = 9;
  public const int UNREGISTERED_USER_REDIRECT = 8;
  public const int ANONYMOUS_REDIRECT = 7;
  public const int USER_EDIT_PAGE_REDIRECT = 6;
  public const int LOGIN_REDIRECT = 5;
  public const int STATE_DESTINATION = 4;
  public const BASE_URL = 'https://login.xecurify.com';
  const MODULE_PACKAGE_NAME = 'OAuth / OpenID Connect';

}
