<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoHooks;

use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Session\AccountProxy;
use Drupal\Core\Url;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;
use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoHooks\MoStdHooksLoader;

class MoUnoHooksLoader
{
  use MoGhostInvoker;
  public function preAuthRespProcess(ModuleHandlerInterface $module_handler, array $query_params = []): void
  {
    $this->call(
      [MoStdHooksLoader::class, 'preAuthRespProcess'],
      ['module_handler' => $module_handler, 'query_params' => $query_params]
    );
  }

  public function postTokenRequest(ModuleHandlerInterface $module_handler, array $token_data, array $state): void
  {
    $this->call(
      [MoStdHooksLoader::class, 'postTokenRequest'],
      ['module_handler' => $module_handler, 'token_data' => $token_data, 'state' => $state]
    );
  }

  Public function getAuthToken(ModuleHandlerInterface $module_handler, array $user_token): void
  {
    $this->call([MoStdHooksLoader::class, 'getAuthToken'], ['module_handler' => $module_handler, 'user_token' => $user_token]);
  }

  /**
   * @throws \Exception
   */
  public function modifyLoginLink(
    ModuleHandlerInterface $module_handler, array &$form, string $config_id, Url $login_url, string $display_name
  ): void
  {
    $this->call(
      [MoStdHooksLoader::class, 'modifyLoginLink'],
      [
        'module_handler' => $module_handler,
        'form' => &$form,
        'config_id' => $config_id,
        'login_url' => $login_url,
        'display_name' => $display_name
      ]
    );
  }

  /**
   * @throws \Exception
   */
  public function preLogout(ModuleHandlerInterface $module_handler, AccountProxy $account): void
  {
    $this->call([MoStdHooksLoader::class, 'preLogout'], ['module_handler' => $module_handler, 'account' => $account]);
  }
}
