<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoLicense\MoDTO;

use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;
use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoLicense\MoDTO\MoStdCustomerConfigSettings as MoStandardCustomerConfigSettings;

class MoUnoLicense
{
  use MoGhostInvoker;

  /**
   * @throws \Exception
   */
  public function readMe(): mixed
  {
    return $this->call([MoStandardCustomerConfigSettings::class, 'readMe']);
  }

  /**
   * @throws \Exception
   */
  public function save(?array $values = []): void
  {
    $this->call([MoStandardCustomerConfigSettings::class, 'save'], ['values' => $values]);
  }

  /**
   * @return void
   * @throws \Exception
   */
  public function removeMe(): void
  {
    $this->call([MoStandardCustomerConfigSettings::class, 'removeMe']);
  }

}
