<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures;

use Drupal\Core\Ajax\CssCommand;
use Drupal\miniorange_oauth_client\MoConstant\MoModuleConstant;
use Drupal\miniorange_oauth_client\MoService\MoLayoutBuilder;

class MoUnoTutorial
{
use MoLayoutBuilder;

  public static function getVideoFrame(): array
  {
    return !MoModuleConstant::SHOW_VIDEO_TUTORIAL ? [] : [
      'video_plyr_frame' =>[
        '#type' => 'details',
        '#id' => 'mo-video-tutorial-frame',
        '#title' => t('Video Setup Guide'),
        '#attributes' => [
          'class' => ['video-plyr-frame'],
        ],
        'iframe' => [
          '#type' => 'html_tag',
          '#tag' => 'iframe',
          '#attributes' => [
            'width' => '100%',
            'height' => '360',
            'src' => 'https://www.youtube.com/embed/SZVa5OoJ2Vg?si=iPiiiFw4MFSErc08',
            'frameborder' => '0',
            'allow' => 'accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture',
            'allowfullscreen' => 'allowfullscreen',
          ],
        ],
      ]
    ];
  }
  public function ajaxEnableVideoTutorialVisibility(&$response, $entity): void {
    if ($entity->isNew()) {
      $response->addCommand(new CssCommand('#mo-video-tutorial-frame', ['display' => 'block']));
    }
  }

  public function buildVideoTutorialFrame(&$result): void
  {
    $result += $this->getVideoFrame();
  }

}
