<?php

namespace Drupal\miniorange_oauth_client\MoHelper\JWTHandler;

use Drupal\miniorange_oauth_client\Entity\MoClientConfiguration;
use Drupal\miniorange_oauth_client\MoHelper\JWTHandler\Utils\JWTUtils;

class HandleJWT
{

  public function __construct(
    private MoClientConfiguration $client_config,
    private string $id_token){
  }

  /**
   * @throws \Exception
   */
  public function getUserAttributesFromIDToken(){
    $jwt = new JWTUtils($this->id_token);

    $grantType = $this->client_config->getGrantType();
    $jwks_uri = $this->client_config->getJkwsEndpoint();
    $client_secret= $this->client_config->getClientSecret();

    $verified= false;
    if($grantType === 'implicit')
      $verified = $jwt->verify_exp_and_nonce();
    if(empty($jwks_uri)){
      if($grantType === 'implicit' && !empty($client_secret))
        $verified = $jwt->verify( $client_secret );
      else
        $verified= true;
    }else{
      $verified = $jwt->verify_from_jwks($jwks_uri);
    }

    if(!$verified){
      throw new \Exception('Somthing went wrong while validating JWT. Either JWKS URI or Client Secret is incorrect.');
    }
    return $jwt->get_decoded_payload();
  }
}
