<?php
/**
 * Provides logging functionalities for the Module.
 *
 * This class handles logging messages into the Drupal database using the
 * watchdog logging system.
 *
 * @author miniOrange
 * @version 1.0
 *
 * @TODO In the log piece need to read the settings for printing loggers and function accordingly.
 * @TODO Need to add export function to export the logs based on user needs.
 */
namespace Drupal\miniorange_oauth_client\MoLibrary;

use Drupal;
use Drupal\miniorange_oauth_client\MoConstant\MoModuleConstant;
use Psr\Log\LoggerInterface;
use Psr\Log\LogLevel;

// Todo add ---------- debug_backtrace()--------- for tracking the files back to find the position of error log
// Todo need check the configuration for printing the logs.
final class MoLogger
{
  const COMMON_ERROR_MESSAGE = "Something went wrong, Please contact the site administrator.";
  public static function getLogLevel()
  {
    return ;
  }
  /**
   * Get Logger object
   *
   * @return LoggerInterface
   */
  private static function getLogger(): LoggerInterface
  {
    return Drupal::logger(MoModuleConstant::MODULE_NAME);
  }


  /**
   * Logs a message to the database.
   *
   * @param string $message
   *   The log message.
   * @param string $level
   *   The severity level (info, warning, error, etc.).
   * @param array $context
   *   Additional context.
   */
  private static function log(string $message, string $level = LogLevel::INFO, array $context = []): void
  {
    // Add if block for verifying the log need to be printed
    if (1) {
      self::getLogger()->log($level, $message, $context);
    }
  }

  /**
   * Add warning type log message to the log
   *
   * @param string $message message - the message that need to be printed in the log
   * @param array $context context - the context array that need to be added in the log
   *
   * @return void
   */
  public static function warning(string $message, array $context = []): void {
    self::log($message, LogLevel::WARNING, $context);
  }

  /**
   * Add emergency type log message to the log
   *
   * @param string $message message - the message that need to be printed in the log
   * @param array $context context - the context array that need to be added in the log
   *
   * @return void
   */
  public static function emergency(string $message, array $context = []): void {
    self::log($message, LogLevel::EMERGENCY, $context);
  }

  /**
   * Add alert type log message to the log
   *
   * @param string $message message - the message that need to be printed in the log
   * @param array $context context - the context array that need to be added in the log
   *
   * @return void
   */
  public static function alert(string $message, array $context = []): void {
    self::log($message, LogLevel::ALERT, $context);
  }

  /**
   * Add critical type log message to the log
   *
   * @param string $message message - the message that need to be printed in the log
   * @param array $context context - the context array that need to be added in the log
   *
   * @return void
   */
  public static function critical(string $message, array $context = []): void {
    self::log($message, LogLevel::CRITICAL, $context);
  }

  /**
   * Add error type log message to the log
   *
   * @param string $message message - the message that need to be printed in the log
   * @param array $context context - the context array that need to be added in the log
   *
   * @return void
   */
  public static function error(string $message, array $context = []): void {
    self::log($message, LogLevel::ERROR, $context);
  }

  /**
   * Add notice type log message to the log
   *
   * @param string $message message - the message that need to be printed in the log
   * @param array $context context - the context array that need to be added in the log
   *
   * @return void
   */
  public static function notice(string $message, array $context = []): void {
    self::log($message, LogLevel::NOTICE, $context);
  }

  /**
   * Add info type log message to the log
   *
   * @param string $message message - the message that need to be printed in the log
   * @param array $context context - the context array that need to be added in the log
   *
   * @return void
   */
  public static function info(string $message, array $context = []): void {
    self::log($message, LogLevel::INFO, $context);
  }

  /**
   * Add debug type log message to the log
   *
   * @param string $message message - the message that need to be printed in the log
   * @param array $context context - the context array that need to be added in the log
   *
   * @return void
   */
  public static function debug(string $message, array $context = []): void {
    self::log($message, LogLevel::DEBUG, $context);
  }

  /**
   * Retrieves log messages from the database.
   *
   * @param array $select_fields
   *   The set of columns that can be fetched from database.
   *
   * @param int $limit
   *   The number of log entries to fetch. Default is 10.
   *
   * @param bool $is_replace
   *   This determines weather the new fields has to be added with the existing or need to be replaced. Default it is false.
   *
   * @return mixed
   *   An array of log entries, each containing:
   *   - uid: Log entry ID.
   *   - type: Log channel type.
   *   - message: Log message.
   *   - variables: Log variables
   *   - severity: Log severity level.
   *   - link: Log location link
   *   - location: Log created location
   *   - referer: Log referer
   *   - hostname: Log host name
   *   - timestamp: Log timestamp
   *
   * @example
   *   $logs = LoggerHelper::getLogs([], 5, false);
   *   foreach ($logs as $log) {
   *     print_r($log);
   *   }
   */
  public static function getLogs(int $limit = 10, array $select_fields = [], bool $is_replace = false): mixed
  {
    try {
      $default = $is_replace ? ['uid', 'timestamp', 'message', 'severity', 'type'] + $select_fields : $select_fields;
      $query = Drupal::database()->select('watchdog', 'w')
        ->fields('w', $default)
        ->orderBy('timestamp', 'DESC')
        ->range(0, $limit);

      return $query->execute()->fetchAll();
    } catch (\Exception $exception) {
      self::error($exception->getMessage());
    }
    return null;
  }
}
