<?php

declare(strict_types=1);

namespace Drupal\miniorange_oauth_client\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the miniOrange group mapping entity type.
 *
 * @ConfigEntityType(
 *   id = "mo_group_mapping",
 *   label = @Translation("miniOrange Group Mapping Entity"),
 *   label_collection = @Translation("miniOrange Group Mapping Entities"),
 *   label_singular = @Translation("miniOrange Group Mapping Entity"),
 *   label_plural = @Translation("miniOrange Group Mapping Entities"),
 *   label_count = @PluralTranslation(
 *     singular = "@count miniOrange Group Mapping Entity",
 *     plural = "@count miniOrange Group Mapping Entities",
 *   ),
 *   handlers = {
 *     "list_builder" = "Drupal\miniorange_oauth_client\MoGroupMappingListBuilder",
 *     "form" = {
 *       "edit" = "Drupal\miniorange_oauth_client\Form\MoGroupMappingForm",
 *     },
 *   },
 *   config_prefix = "mo_group_mapping",
 *   admin_permission = "administer mo_group_mapping",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid",
 *     "enable_group_mapping" = "enable_group_mapping",
 *     "keep_existing_groups" = "keep_existing_groups",
 *     "group_attribute" = "group_attribute",
 *     "mapped_fields" = "mapped_fields",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "description",
 *     "enable_group_mapping",
 *     "keep_existing_groups",
 *     "group_attribute",
 *     "mapped_fields",
 *   },
 * )
 */
final class MoGroupMapping extends ConfigEntityBase {

  /**
   * The example ID.
   */
  protected string $id;

  protected ?bool $enable_group_mapping = false;

  protected ?bool $keep_existing_groups = false;

  protected ?string $group_attribute = '';
  protected ?array $mapped_fields = [];


  public function getId(): string
  {
    return $this->id;
  }

  public function setId(string $id): MoGroupMapping
  {
    $this->id = $id;
    return $this;
  }

  public function getEnableGroupMapping(): ?bool
  {
    return $this->enable_group_mapping;
  }

  public function setEnableGroupMapping(bool $enable_group_mapping): MoGroupMapping
  {
    $this->enable_group_mapping = $enable_group_mapping;
    return $this;
  }

  public function getKeepExistingGroups(): ?bool
  {
    return $this->keep_existing_groups;
  }

  public function setKeepExistingGroups(bool $keep_existing_groups): MoGroupMapping {
    $this->keep_existing_groups = $keep_existing_groups;
    return $this;
  }

  public function getGroupAttribute(): ?string
  {
    return $this->group_attribute;
  }

  public function setGroupAttribute(string $group_attribute): MoGroupMapping
  {
    $this->group_attribute = $group_attribute;
    return $this;
  }

  public function getMappedFields(): ?array
  {
    return $this->mapped_fields;
  }

  public function setMappedFields(?array $mapped_fields): MoGroupMapping
  {
    $this->mapped_fields = $mapped_fields;
    return $this;
  }

  public static function readMe(string $id): self
  {
    return self::load($id) ?? self::create(['id' => $id]);
  }
}
