<?php

namespace Drupal\miniorange_oauth_client\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\miniorange_oauth_client\Entity\MoClientConfiguration;

class MoTestConfigurationResultForm extends FormBase
{
  private mixed $resource_owner;
  private mixed $client_config;

  public function getFormId()
  {
    return 'mo_test_configuration_result_form';
  }

  public function __construct(?array $resource_owner, MoClientConfiguration $client_config) {
    $this->resource_owner = $resource_owner;
    $this->client_config = $client_config;
  }

  public static function create($container) {
    return new static(NULL, NULL);
  }


  public function buildForm(array $form, FormStateInterface $form_state)
  {
    $module_path = \Drupal::service('extension.list.module')->getPath("miniorange_oauth_client");
    $base_url = Url::fromUri('internal:/', ['absolute' => true])->toString();
    $image_path = $base_url . '/' . $module_path . '/assets/img/green_check.png';
    $user_name = $this->resource_owner['email'] ?? 'User';

    $redirect_url = Url::fromRoute('mo_configuration.edit', [
      'mo_client_config' => $this->client_config->id(),
      'tab' => 'attribute_mapping',
    ])->toString();

// Attach styles
    $form['#attached']['html_head'][] = [[
      '#tag' => 'style',
      '#value' => '
    .mo-test-wrapper {
      text-align: center;
      font-family: "Segoe UI", sans-serif;
    }
    .mo-test-header {
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
      margin-bottom: 15px;
    }
    .mo-check-img {
      max-width: 40px;
    }
    .mo-success-title {
      font-size: 18pt;
      font-weight: bold;
      color: green;
    }
    .mo-greeting {
      font-size: 14pt;
      margin: 15px 0;
    }
    .mo-attribute-table th,
    .mo-attribute-table td {
      padding: 8px 12px;
      border: 1px solid #ddd;
      text-align: left;
    }
    .mo-attribute-table tr:nth-child(even) {
      background-color: #f9f9f9;
    }
    .mo-divider {
      height: 1px;
      background: #ccc;
      margin: 20px 0;
    }
    .mo-word-break {
      word-break: break-all;
    }
    table caption {
      text-align: left;
      font-size: 13pt;
      font-weight: bold;
      margin: 20px 0 10px;
    }
  ',
    ], 'mo_test_inline_styles'];

// Header markup
    $form['markup_wrapper'] = [
      '#markup' => '
    <div class="mo-test-wrapper">
      <div class="mo-test-header">
        <img class="mo-check-img" src="' . $image_path . '" alt="Success" />
        <div class="mo-success-title">TEST SUCCESSFUL</div>
      </div>
      <div class="mo-greeting"><strong>Hello</strong>, ' . htmlspecialchars($user_name) . '</div>
      <div class="mo-divider"></div>
      <div>Please click on "<b>Configure Mappings</b>" button below to proceed.</div>
    </div>',
    ];

// Table for attributes
    $form['attributes'] = [
      '#type' => 'container',
      '#attributes' => ['style' => 'display:flex; flex-direction: column;'],
    ];
    $form['attributes']['attribute_table'] = [
      '#type' => 'table',
      '#header' => [
        $this->t('Attribute Name'),
        $this->t('Attribute Value'),
      ],
      '#caption' => $this->t('Attributes Received'),
      '#attributes' => ['class' => ['mo-attribute-table']],
    ];

    foreach ($this->resource_owner as $attr => $val) {
      $form['attributes']['attribute_table'][] = [
        'attr_name' => ['#markup' => '<div class="mo-word-break">' . htmlspecialchars($attr) . '</div>'],
        'attr_value' => ['#markup' => '<div class="mo-word-break">' . htmlspecialchars(is_array($val) ? json_encode($val) : $val) . '</div>'],
      ];
    }

// Buttons
    $form['buttons'] = [
      '#type' => 'container',
      '#attributes' => ['style' => 'text-align:center; margin-top: 20px;'],
      'configure' => [
        '#type' => 'button',
        '#value' => $this->t('Configure Mappings'),
        '#attached' => [
          'html_head' => [[[
            '#tag' => 'script',
            '#value' => "function close_and_redirect(){ window.opener.location.href = '$redirect_url'; self.close(); }"
          ], 'close_and_redirect_script']],
        ],
        '#attributes' => [
          'class' => ['button', 'button--primary', 'button--small'],
          'onclick' => 'close_and_redirect()',
        ],
      ],
      'done' => [
        '#type' => 'button',
        '#value' => $this->t('Done'),
        '#attributes' => [
          'class' => ['button', 'button--danger', 'button--small'],
          'onclick' => 'self.close();',
        ],
      ],
    ];
    return $form;
  }

  public function submitForm(array &$form, FormStateInterface $form_state)
  {
    // TODO: Implement submitForm() method.
  }
}
