<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoClientConfiguration\MoAuthProtocols\MoProtocols;

use Drupal\miniorange_oauth_client\Entity\MoClientConfiguration;
use Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoClientConfiguration\MoGrant\MoUnoReadGrants;
use Drupal\miniorange_oauth_client\MoHelper\MoUtilities;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;

class MoUnoOAuth20
{
  use MoGhostInvoker;
  public function getProtocol(array &$protocols): void
  {
    $protocols['OAuth'] = t('OAuth 2.0 Application');
  }

  public function gatherTokenFromIDP(MoClientConfiguration $client_config, ?string $code = '', array $query_params = [])
  {
    $content =  $this->call(
      [MoUnoReadGrants::class, 'gatherTokenFromIDP'],
      ['client_config' => $client_config, 'code' => $code, 'query_params' => $query_params]
    );

    if (empty($content) || !isset($content['access_token'])) {
      throw new \Exception(
        "Invalid response received while fetching access token -<br><br> Response => <pre><code>" . print_r($content, true) . "<pre><code>"
      );
    }
    return $content;
  }

  /**
   * @throws \Exception
   */
  public function gatherUserInfoFromIDP(MoClientConfiguration $client_config, array $token_data)
  {
    $access_token = $token_data['access_token'];
    if (empty($access_token)) {
      throw new \Exception("Access token is needed for gathering user information in the OAuth 2.0 flow.");
    }
    $user_info = MoUtilities::buildGetRequest(['Authorization' => 'Bearer ' . $access_token], $client_config->getUserinfoEndpoint());

    // this part is to gather group info of the user
    if (!empty($group_info_ep = $client_config->getGroupInfoEndpoint())) {
      $group_info = MoUtilities::buildGetRequest(['Authorization' => 'Bearer ' . $access_token], $group_info_ep);
      $user_info = array_merge($user_info, $group_info ?? []);
    }
    return $user_info;
  }
}
