<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoLicense\EventSubscriber;

use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoLicense\EventSubscriber\MoStdLicenseSubscriber;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;

class MoUnoLicenseSubscriber
{
use MoGhostInvoker;

  /**
   * This function will execute after the response is sent to the user,
   *  once after the response is terminated it will get executed at the priority of 10.
   *
   * @return void no return values
   * @throws \Exception
   */
  public function onTerminate(): void
  {
    $this->call([MoStdLicenseSubscriber::class, 'onTerminate']);
  }

  /**
   * This function is to display the license expiry to the administrators.
   * The licensing and subscription part are completely handled inside both of those modules.
   *
   * @return void
   * @throws \Exception
   */
  public function onKernelRequest(): void
  {
    $this->call([MoStdLicenseSubscriber::class, 'onKernelRequest']);
  }

  /**
   * @throws \Exception
   */
  public function routeList(): array
  {
    return $this->call([MoStdLicenseSubscriber::class, 'routeList']) ?? [];
  }
}
