<?php
/**
 * This class file helps in providing various functionalities for support related operations from MiniOrange,
 *
 * @author MiniOrange
 * @version 1.0
 */

namespace Drupal\miniorange_oauth_client\MoHelper;

use Drupal\Component\Utility\Html;
use Drupal\Core\Url;
use Drupal\miniorange_oauth_client\MoConstant\MoModuleConstant;
use Drupal\miniorange_oauth_client\MoLibrary\MoCacheLibrary;
use Drupal\miniorange_oauth_client\MoLibrary\MoLogger;
use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\Exception\RequestException;

class MoSupport
{
  /**
   * This function helps in building support Icon that can be displayed on the forms.
   * On clicking on this a popup will appear with autofilled email, where user can write their query to seek support
   *
   * @param array $form form-field array
   *
   * @return void
   */
  public static function buildSupportIcon(array &$form): void
  {
    // Build absolute base URL
    $base_url = Url::fromUri('internal:/', ['absolute' => TRUE])->toString();

    // Get path to the module's assets
    $module_path = \Drupal::service('extension.list.module')->getPath(MoModuleConstant::MODULE_NAME);

    // Add the support icon to the form
    $form['customer_support_icon'] = [
      '#markup' => sprintf(
        '<a class="use-ajax mo-support-button" href="%s">
         <img src="%s" alt="%s">
       </a>',
        Html::escape(Url::fromRoute(MoModuleConstant::CUSTOMER_SUPPORT_URL)->toString()), //build customer support link
        Html::escape($base_url . $module_path . '/assets/img/mo_customer_support.png'),
        Html::escape(t('Support Icon'))
      ),
    ];

    $form['#attached']['library'][] = 'core/drupal.ajax';
    $form['#attached']['library'][] = 'core/drupal.dialog.ajax';
    $form['#attached']['library'][] = 'miniorange_oauth_client/common_layout';
  }
}
