<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoOperations;

use Drupal\miniorange_oauth_client\Entity\MoClientSettings;
use Drupal\miniorange_oauth_client\MoConstant\MoModuleConstant;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;
use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoOperations\MoStdLoginOperations as MoStandardLoginOperations;
use Drupal\user\Entity\User;

class MoUnoLoginOperations
{
use MoGhostInvoker;
  public function userLogin(User $user, string $client_id): void
  {
    $client_settings = MoClientSettings::readMe($client_id);
    if ((bool)reset($user->toArray()['status'])['value'] ?? false){
      user_login_finalize($user);
      \Drupal::request()->attributes->set(
        'mo_redirect_url',
        (\Drupal::request()->attributes->get('mo_redirect_url') ?? []) +
        [MoModuleConstant::LOGIN_REDIRECT => $client_settings->getLoginRedirectUrl()]
      );
    }
  }

  public function buildOrUpdateLoginReports(array $report_info, ?string $client_config_id = null) {
    return $this->call(
      [MoStandardLoginOperations::class, 'buildOrUpdateLoginReports'],
      ['report_info' => $report_info, 'client_config_id' => $client_config_id]
    );
  }
}
