<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoOperations;

use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoOperations\MoStdLogoutOperation;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;


class MoUnoLogoutOperation
{
  use MoGhostInvoker;

  /**
   * @throws \Exception
   */
  public function userLogout($account): void
  {
   $this->call([MoStdLogoutOperation::class, 'userLogout'], ['account' => $account]);
  }

  /**
   * @throws \Exception
   */
  public function idpInitiatedLogout(): void
  {
    $this->call([MoStdLogoutOperation::class, 'idpInitiatedLogout']);
  }
}
