<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoReplaceYML;

use Drupal\miniorange_oauth_client\MoConstant\MoModuleConstant;
use Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoUnoLicenseTierManager;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;

class MoUnoModuleMenus
{
  use MoGhostInvoker;

  /**
   * @throws \Exception
   */
  public function menuLinksDiscoveredAlter(array &$links): void
  {
    if ($this->call([MoUnoLicenseTierManager::class, 'getLicenseVersion']) !== MoModuleConstant::MO_FREE_VERSION) {
      $key = 'mo_license.customer_config';
      $route_name = 'mo_license.customer_config';
    } else {
      $key = 'entity.mo_client_config.collection';
      $route_name = 'entity.mo_client_config.collection';
    }

    $links[$key] = [
      'title' => t('miniOrange OAuth Client'),
      'description' => t('Configure the Identity Providers that follow the OAuth or OpenID Connect protocols to enable Single Sign-On (SSO) for users.'),
      'parent' => 'user.admin_index',
      'route_name' => $route_name
    ];
  }
}
