<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\miniorange_oauth_client\MoConstant\MoModuleConstant;
use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoStdModuleUpgrade;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;

class MoUnoModuleUpgrade
{
  use MoGhostInvoker;

  /**
   * @throws \Exception
   */
  public function updateProjectsAlter(array &$projects): void
  {
    $this->call([MoStdModuleUpgrade::class, 'updateProjectsAlter'], ['projects' => &$projects]);
  }

  public function updateManagerUpdateForm(array &$form, FormStateInterface $form_state): void
  {
    $this->call([MoStdModuleUpgrade::class, 'updateManagerUpdateForm'], ['form' => &$form, 'form_state' => $form_state]);
  }

  /**
   * This function helps in achieving the dynamic config option after installing the module and dynamically change the module version based on the tier
   *
   * @param array $form
   * @param FormStateInterface $form_state
   * @return void
   * @throws \Exception
   */
  public function attachModuleVersion(array &$form, FormStateInterface $form_state): void
  {
    if (isset($form['modules'][MoModuleConstant::MODULE_PACKAGE_NAME][MoModuleConstant::MODULE_NAME])) {
      $form['modules'][MoModuleConstant::MODULE_PACKAGE_NAME][MoModuleConstant::MODULE_NAME]['version'] = [
        '#markup' => $this->call([MoUnoLicenseTierManager::class, 'getModuleVersion'])
      ];
      $form['modules'][MoModuleConstant::MODULE_PACKAGE_NAME][MoModuleConstant::MODULE_NAME]['links']['configure'] = [
        '#type' => 'link',
        '#title' => t('Configure <span class="visually-hidden">@module</span>', ['@module' => 'miniOrange OAuth Client']),
        '#url' =>
          Url::fromRoute(
            $this->call([MoUnoLicenseTierManager::class, 'getLicenseVersion']) == MoModuleConstant::MO_FREE_VERSION ?
              'entity.mo_client_config.collection' : 'mo_license.customer_config'
          ),
        '#options' => [
          'attributes' => [
            'class' => [
              'module-link',
              'module-link-configure'
            ]
          ]
        ]
      ];
    }
  }
}
