<?php
/**
 * This file helps in building the layouts for the forms
 *
 * @author MiniOrange
 * @version 1.0
 *
 * TODO : Both functions can be written as one function but for that need to fix all form CSS
 */
namespace Drupal\miniorange_oauth_client\MoService;

use Drupal\miniorange_oauth_client\MoConstant\MoModuleConstant;
use Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoUnoLicenseTierManager;

/**
 * This trait class is for generating the layout
 */
trait MoLayoutBuilder
{
  /**
   * This function is for creating outline AKS border for covering the contents
   *
   * @return array returns a form element
   */
  private function getOuterLayout(): array
  {
    return [
      '#type' => 'fieldset',
      '#attributes' => ['class' => ['mo-outline']],
    ];
  }

  public function getTutorialLayout(): array
  {
    return [
      '#type' => 'container',
      '#attributes' => ['class' => ['mo-tutorial-outline']],
    ];
  }

  /**
   * This function is for creating the border image
   *
   * @return array returns a form element
   */
  private function getPoweredBy(): array
  {
    $module_path = \Drupal::service('extension.list.module')->getPath(MoModuleConstant::MODULE_NAME);
    return [
      '#type' => 'markup',
      '#markup' => '<img src="/'.$module_path.'/assets/img/mo_logo.png" alt="logo" class="mo-powered">',
    ];
  }

  /**
   * This function is to append the layout with the form,
   *
   * @param array $elements The list of elements that need to be added inside the layout.
   *
   * @return array
   */
  public function buildMOLayout(array $elements, bool $show_powered_by = true): array
  {
    // css library for controlling the overall layout.
    $elements['libraries']['#attached']['library'][] = 'miniorange_oauth_client/common_layout';
    $form['mo_outline'] = self::getOuterLayout();
    $form['mo_outline'] += $elements;
    if($show_powered_by) {
      $form['mo_outline']['powered'] = self::getPoweredBy();
    }

    return $form;
  }

  public function getVerticalLayoutMenus(array $element, array $menu_data, ?string $default_tab = null): array
  {
    $element['layout'] = [
      '#type' => 'container',
    ];

    // Left sidebar menu.
    $element['layout']['sidebar'] = [
      '#type' => 'container',
      'menu' => [
        '#type' => 'vertical_tabs',
      ],
    ];
    if (!empty($default_tab) && isset($menu_data[$default_tab])) {
      $menu_data = [$default_tab => $menu_data[$default_tab]] + array_diff_key($menu_data, [$default_tab => true]);
    }

    foreach($menu_data as $menu_key => $menu_value) {
      $element['layout']['sidebar']['menu'][$menu_key] = [
        '#type' => 'details',
        '#title' => $this->t($menu_value['title']),
        '#group' => 'menu',
        'form' => $menu_value['form'],
      ];
    }
    return $element;
  }

  public function modifyFormTitleOnTier(array &$elements) {
    $current_lic_ver = $this->call([MoUnoLicenseTierManager::class, 'getLicenseVersion']);

    foreach ($elements as $key => &$element) {
      if (is_array($element)) {
        if (isset($element['#tier'])) {
          $tier = $element['#tier'];
          $allowed = in_array($current_lic_ver, $tier);

          // Create hidden flag element for state-based disabling
          $elements[$key . '_tier_flag'] = [
            '#type' => 'hidden',
            '#value' => $allowed ? 1 : 0,
            '#attributes' => ['class' => [$key . '-tier-flag']],
          ];

          // Inject #states condition only if already using #states
          $element['#states']['disabled'][] = [':input.' . $key . '-tier-flag' => ['value' => '0']];

          // Modify the title to show tier info
          if (!$allowed && isset($element['#title']) && !str_contains($element['#title'], implode(', ', $tier))) {
            $element['#title'] .= ' <b>(' . implode(', ', $tier) . ')</b>';
          }

          unset($element['#tier']);
        }

        // Recursively modify child elements
        $this->modifyFormTitleOnTier($element);
      }
    }
  }


}
