(function ($, Drupal) {
  let initial_load = true;

  const updateAuthenticationMethodDefaultValue = (initial_load, grant_type) => {
    if(!initial_load && grant_type === 'implicit') {
      // used vanilla JS in this part because it usually loads after the page is completely loaded.
      const frame = document.getElementById('authentication-method-frame');
      if (frame) {
        frame.style.display = 'none';
      }
    } else {
      let value = document.getElementById('authentication-method-default-value').value;
      if (!initial_load && grant_type === 'authorization_code_with_pkce') {
        value = 'none';
      }
      $('input[name=authentication_method][value='+value+']').prop('checked', true).end();
    }
  }

  Drupal.behaviors.ajaxEventHandler = {
    attach: function (context, settings) {
      $('#radio-buttons-wrapper', context).each(function () {
        const element = $(this);
        if (!element.data('ajax-event-handled')) {
          updateAuthenticationMethodDefaultValue(initial_load, document.getElementById('grant_type').value);
          initial_load = false;

          element.data('ajax-event-handled', true);
        }
      });
    }
  };
}(jQuery, Drupal));
