(function ($, Drupal) {
  Drupal.behaviors.copyIcon = {
    attach: function (context, settings) {
      $('.mo-copy-icon-span', context)
        .off('click.copyIcon')
        .on('click.copyIcon', function () {
          const $wrapper = $(this);
          const $button = $wrapper.find('a.button, button').first();
          const $icon = $wrapper.find('.mo-copy-icon');
          const targetId = $wrapper.data('target');
          const input = document.getElementById(targetId);

          if (input) {
            
            const value = input.getAttribute('data-copy-value') || input.value.trim();

            // Remove any existing message
            $wrapper.find('.mo-copy-msg').remove();

            if (value) {
              navigator.clipboard.writeText(value).then(() => {
                // Prefer updating the button text to indicate success
                if ($button.length) {
                  const originalText = $button.text();
                  $button.text('Copied').addClass('mo-btn-copied');
                  setTimeout(() => {
                    $button.text(originalText).removeClass('mo-btn-copied');
                  }, 1200);
                } else {
                  // Fallback inline message next to the icon
                  const $msg = $('<span class="mo-copy-msg">Copied!</span>');
                  $icon.after($msg);
                  setTimeout(() => $msg.fadeOut(300, () => $msg.remove()), 1000);
                }
              });
            } else {
              // Show "No data to copy"
              if ($button.length) {
                const originalText = $button.text();
                $button.text('No data').addClass('mo-btn-copied');
                setTimeout(() => {
                  $button.text(originalText).removeClass('mo-btn-copied');
                }, 1200);
              } else {
                const $msg = $('<span class="mo-copy-msg">No data to copy!</span>');
                $icon.after($msg);
                setTimeout(() => $msg.fadeOut(300, () => $msg.remove()), 1500);
              }
            }
          }
        });
    }
  };
})(jQuery, Drupal);
