(function ($, Drupal) {
  Drupal.behaviors.callNotifyUsModal = {
    attach: function (context, settings) {
      if (!$(context).is(document)) return;

      // ✅ Only trigger once per page load
      if (!$(context).hasClass('notify-us-url-called')) {
        $(context).addClass('notify-us-url-called');

        const ajax = new Drupal.Ajax(null, $(context), {
          url: Drupal.url('admin/config/people/mo-oauth-client/notify-us'),
          dialogType: 'modal',
          progress: { type: 'fullscreen' }
        });

        ajax.execute();
      }

      // ✅ Unbind old modal close listener (only from context)
      $(context).off('dialogclose.moNotifyUs', '.mo-notify-us-dialog');

      // ✅ Bind to dialog close of your module's modal
      $(context).on('dialogclose.moNotifyUs', '.mo-notify-us-dialog', function () {
        $.ajax({
          url: Drupal.url('admin/config/people/mo-oauth-client/notify-us'),
          method: 'POST',
          dataType: 'json',
          data: {
            action: 'close',
            page_for: 'notify-us'
          }
        });
      });
    }
  };
})(jQuery, Drupal);
