<?php

declare(strict_types=1);

namespace Drupal\miniorange_oauth_client\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the miniOrange attribute mapping entity type.
 *
 * @ConfigEntityType(
 *   id = "mo_attribute_mapping",
 *   label = @Translation("miniOrange Attribute Mapping Entity"),
 *   label_collection = @Translation("miniOrange Attribute Mapping Entities"),
 *   label_singular = @Translation("miniorange attribute mapping entity"),
 *   label_plural = @Translation("miniorange attribute mapping entities"),
 *   label_count = @PluralTranslation(
 *     singular = "@count miniOrange attribute mapping entity",
 *     plural = "@count miniOrange attribute mapping entities",
 *   ),
 *   config_prefix = "mo_attribute_mapping",
 *   handlers = {
 *      "form" = {
 *        "edit" = "Drupal\miniorange_oauth_client\Form\MoAttributeMappingForm"
 *      },
 *    },
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "id",
 *   },
 *   config_export = {
 *     "id",
 *     "email_attribute",
 *     "username_attribute",
 *     "custom_attributes"
 *   },
 * )
 */
final class MoAttributeMapping extends ConfigEntityBase {

  protected string $id;
  protected ?string $email_attribute = '';
  protected ?string $username_attribute = '';
  protected ?array $custom_attributes = [];

  public function getId(): string
  {
    return $this->id;
  }

  public function setId(string $id): MoAttributeMapping
  {
    $this->id = $id;
    return $this;
  }

  public function getEmailAttribute(): ?string
  {
    return $this->email_attribute;
  }

  public function setEmailAttribute(?string $email_attribute): MoAttributeMapping
  {
    $this->email_attribute = $email_attribute;
    return $this;
  }

  public function getUsernameAttribute(): ?string
  {
    return $this->username_attribute;
  }

  public function setUsernameAttribute(?string $username_attribute): MoAttributeMapping
  {
    $this->username_attribute = $username_attribute;
    return $this;
  }

  public function getCustomAttributes(): ?array
  {
    return $this->custom_attributes;
  }

  public function setCustomAttributes(?array $custom_attributes): MoAttributeMapping
  {
    $this->custom_attributes = $custom_attributes;
    return $this;
  }

  public static function readMe(string $id): self
  {
    return self::load($id) ?? self::create(['id' => $id]);
  }
}
