<?php

declare(strict_types=1);

namespace Drupal\miniorange_oauth_client\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;

/**
 * Defines the miniOrange login reports entity class.
 *
 * @ContentEntityType(
 *   id = "mo_login_reports",
 *   label = @Translation("miniOrange Login Reports Entity"),
 *   label_collection = @Translation("miniOrange Login Reports Entities"),
 *   label_singular = @Translation("miniOrange Login Reports Entity"),
 *   label_plural = @Translation("Login Reports"),
 *   label_count = @PluralTranslation(
 *     singular = "@count miniOrange Login Reports Entities",
 *     plural = "@count miniOrange Login Reports Entities",
 *   ),
 *   handlers = {
 *     "list_builder" = "Drupal\miniorange_oauth_client\MoEntityListBuilder\MoLoginReportListBuilder",
 *   },
 *   base_table = "mo_login_reports",
 *   admin_permission = "mo_administrator",
 *   entity_keys = {
 *     "id" = "id",
 *     "uuid" = "uuid",
 *     "sort" = "created_at"
 *   },
 *   links = {
 *     "collection" = "/admin/config/people/mo-oauth-client/login-reports",
 *   },
 * )
 */
final class MoLoginReport extends ContentEntityBase
{

    /**
     * {@inheritdoc}
     */
    public static function baseFieldDefinitions(EntityTypeInterface $entity_type): array
    {

        $fields = parent::baseFieldDefinitions($entity_type);

        $fields['uuid'] = BaseFieldDefinition::create('uuid')
            ->setLabel(t('UUID'))
            ->setDescription(t('The universally unique identifier (UUID).'))
            ->setReadOnly(TRUE);

        $fields['username'] = BaseFieldDefinition::create('string')
            ->setLabel(t('Username'))
            ->setDescription(t('The username of the user.'))
            ->setSettings(['max_length' => 256]);

        $fields['status'] = BaseFieldDefinition::create('string')
            ->setLabel(t('Status'))
            ->setDescription(t('Status of the SSO.'))
            ->setSettings(['max_length' => 256]);

        $fields['application'] = BaseFieldDefinition::create('string')
            ->setLabel(t('Application'))
            ->setDescription(t('SSO Application name.'))
            ->setSettings(['max_length' => 256]);

        $fields['created_at'] = BaseFieldDefinition::create('created')
            ->setLabel(t('Created'))
            ->setDescription(t('The time that the login report was created.'));

        $fields['email'] = BaseFieldDefinition::create('email')
            ->setLabel(t('Email'))
            ->setDescription(t('The email address of the user.'));

        $fields['ip_address'] = BaseFieldDefinition::create('string')
            ->setLabel(t('IP Address'))
            ->setDescription(t('IP address of the user machine.'))
            ->setSettings(['max_length' => 256]);

        $fields['navigation_url'] = BaseFieldDefinition::create('string_long')
            ->setLabel(t('Navigation URL'))
            ->setDescription(t('Navigation URL from where the SSO was initiated.'));

        return $fields;
    }

    public static function loadByProperties(array $values): array
    {
      return \Drupal::entityTypeManager()->getStorage('mo_login_reports')->loadByProperties($values);
    }
}
