<?php

declare(strict_types=1);

namespace Drupal\miniorange_oauth_client\EventSubscriber;

use Drupal\Core\Routing\TrustedRedirectResponse;
use Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoOperations\MoUnoClientSettings;
use Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoUnoModuleSettingsSubscriber;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\Event\ResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 *
 * @todo need to bring the ghost invoker component inside this part to perform operations dynamically.
 * @todo Add description for this subscriber.
 */
final class MoModuleSettingsSubscriber implements EventSubscriberInterface {
  use MoGhostInvoker;
  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      KernelEvents::REQUEST => ['onKernelRequest'],
      KernelEvents::RESPONSE => ['onKernelResponse'],
    ];
  }

  public function onKernelRequest(RequestEvent $event): void {
    $this->call([MoUnoClientSettings::class, 'validateUserSession']);
    $this->call([MoUnoModuleSettingsSubscriber::class, 'onKernelRequest'], ['event' => &$event]);
  }


  public function onKernelResponse(ResponseEvent $event): void
  {
    // this function is responsible for performing SLO from IDP.
    $request = $event->getRequest();
    if ($request->get('_route') == 'user.logout' && !empty($redirect_url = $request->get('mo_slo_redirect_to_idp_url'))) {
      (new TrustedRedirectResponse($redirect_url))->send();
    }
  }
}
