<?php

declare(strict_types=1);

namespace Drupal\miniorange_oauth_client\EventSubscriber;

use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoUnoLicenseRouteBuilder;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;
use Symfony\Component\Routing\RouteCollection;

/**
 * Route subscriber.
 */
final class MoRouteSubscriber extends RouteSubscriberBase {
use MoGhostInvoker;

  /**
   * This function helps to add routes for fetching and removing license from the module,
   * In the Single code base to support the free tier have introduced a workaround to add routes dynamically
   *  based on the tier name
   *
   * So as of the current approach we need license routes only for the Paid tiers we have the licensing routes.
   *
   * {@inheritdoc}
   * @throws \Exception
   */
  protected function alterRoutes(RouteCollection $collection): void {
    $this->call([MoUnoLicenseRouteBuilder::class, 'buildRoute'], ['collection' => $collection]);
  }
}
