<?php

namespace Drupal\miniorange_oauth_client\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\miniorange_oauth_client\Entity\MoAttributeMapping;
use Drupal\miniorange_oauth_client\Entity\MoClientConfiguration;
use Drupal\miniorange_oauth_client\Entity\MoClientSettings;
use Drupal\miniorange_oauth_client\Entity\MoGroupMapping;
use Drupal\miniorange_oauth_client\Entity\MoRoleMapping;
use Drupal\miniorange_oauth_client\Entity\MoProfileMapping;
use Drupal\miniorange_oauth_client\MoHelper\MoSupport;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;
use Drupal\miniorange_oauth_client\MoService\MoLayoutBuilder;

class MoConfigurationEditForm extends FormBase
{
use MoGhostInvoker;
use MoLayoutBuilder;
  public function getFormId()
  {
    return "mo_configurations_edit_form_frame";
  }

  public function buildForm(array $form, FormStateInterface $form_state): array
  {
    $client_config = $this->getRequest()->get(MoClientConfiguration::getEntityId());
    $default_tab_to_open = $this->getRequest()->get('tab');
    $attribute_mapping = MoAttributeMapping::load($client_config->id()) ?? MoAttributeMapping::create(['id' => $client_config->id()]);
    $role_mapping = MoRoleMapping::load($client_config->id()) ?? MoRoleMapping::create(['id' => $client_config->id()]);
    $profile_mapping = MoProfileMapping::load($client_config->id()) ?? MoProfileMapping::create(['id' => $client_config->id()]);
    $group_mapping = MoGroupMapping::load($client_config->id()) ?? MoGroupMapping::create(['id' => $client_config->id()]);
    $client_settings = MoClientSettings::load($client_config->id()) ?? MoClientSettings::create(['id' => $client_config->id()]);

    $menu_data['client_config'] = [
      'title' => 'Client Configuration',
      'form' => \Drupal::service('entity.form_builder')->getForm($client_config, 'edit')
    ];
    $menu_data['attribute_mapping'] = [
      'title' => 'Attribute Mapping',
      'form' => \Drupal::service('entity.form_builder')->getForm($attribute_mapping, 'edit')
    ];
    $menu_data['role_mapping'] = [
      'title' => 'Role Mapping',
      'form' => \Drupal::service('entity.form_builder')->getForm($role_mapping, 'edit')
    ];
    $menu_data['profile_mapping'] = [
      'title' => 'Profile Mapping',
      'form' => \Drupal::service('entity.form_builder')->getForm($profile_mapping, 'edit')
    ];
    $menu_data['group_mapping'] = [
      'title' => 'Group Mapping',
      'form' => \Drupal::service('entity.form_builder')->getForm($group_mapping, 'edit')
    ];
    $menu_data['client_setting'] = [
      'title' => 'Client Settings',
      'form' => \Drupal::service('entity.form_builder')->getForm($client_settings, 'edit')
    ];

    !empty($default_tab_to_open) ||
    !in_array($default_tab_to_open, array_keys($menu_data)) ||
    $default_tab_to_open = null;
    $result = $this->getVerticalLayoutMenus($form, $menu_data, $default_tab_to_open);
    MoSupport::buildSupportIcon($result);
    return $result;
  }

  public function processForm(array &$form, FormStateInterface $form_state)
  {
    return $form;
  }

  public function submitForm(array &$form, FormStateInterface $form_state)
  {
    // TODO: Implement submitForm() method.
  }
}
