<?php

namespace Drupal\miniorange_oauth_client\Form;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Render\Markup;
use Drupal\miniorange_oauth_client\MoConstant\MoModuleConstant;
use Drupal\miniorange_oauth_client\MoHelper\MoFallBackSupport;
use Drupal\miniorange_oauth_client\MoHelper\MoSupport;
use Drupal\miniorange_oauth_client\MoLibrary\MoLogger;
use Drupal\miniorange_oauth_client\MoService\MoLayoutBuilder;

/**
 * Provides a setup guide form for the miniOrange OAuth Client module.
 * This form displays a categorized list of supported OAuth and OIDC applications
 * Each application is shown with its logo, and optionally,
 * documentation and video links for configuration guidance.
 */
class MoSetupGuide extends FormBase
{
  use MoLayoutBuilder;

  public function getFormId()
  {
    return 'miniorange_oauth_client_setup_guide';
  }

  public function buildForm(array $form, FormStateInterface $form_state)
  {

    $form['markup_library'] = [
      '#attached' => [
        'library' => ['miniorange_oauth_client/setupguide_page_layout'],
      ],
    ];

    $form['mo_application_list'] = [
      '#markup' => '<ul id="mo_search_custom_ul" class="mo-wrap mo-flex-container">' . implode('', self::appList()) . '</ul>',
    ];


    MoSupport::buildSupportIcon($form);
    return self::buildMOLayout($form);
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {}

  public static function appList(): array
  {
    $base_url = \Drupal::request()->getSchemeAndHttpHost() . \Drupal::request()->getBasePath();
    $url_path = $base_url . '/' . \Drupal::service('extension.list.module')->getPath('miniorange_oauth_client') . '/assets';
    $apps = MoFallBackSupport::idpInfoHelper();

    foreach ($apps as $app) {
      $guide_link = '<a href="' . $app['setupGuideLink'] . '" target="_blank" title="View Guide"><img class="mo-icon" src="' . $url_path . '/img/icons8-document-30.png" alt="Guide"></a>';
      $video_link = '<a href="' . $app['videoGuideLink'] . '" target="_blank" title="Watch Video"><img class="mo-icon" src="' . $url_path . '/img/icons8-video-24.png" alt="Video"></a>';

      $html = '<li class="mo-flex-item" id="' . $app['id'] . '">
            <img class="img-mo-logo" src="' . $url_path . '/Providers/' . $app['id'] . '.png"><br>' . $app['clientName'] . '
                <div class="mo-app-links">' . $guide_link . $video_link . '</div>
            </li>';

      $markup[] = Markup::create($html);
    }
    return $markup ?? [];
  }
}
