<?php

namespace Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoClientConfiguration\MoAuthProtocols;

use Drupal\miniorange_oauth_client\Entity\MoClientConfiguration;
use Drupal\miniorange_oauth_client\MoFeatures\MoStandardFeatures\MoClientConfiguration\MoAuthProtocols\MoStdReadProtocols as MoStandardReadProtocols;
use Drupal\miniorange_oauth_client\MoFeatures\MoUnoFeatures\MoClientConfiguration\MoAuthProtocols\MoProtocols\MoUnoOAuth20;
use Drupal\miniorange_oauth_client\MoLibrary\MoGhostInvoker;

class MoUnoReadProtocols
{
  use MoGhostInvoker;

  /**
   * @throws \Exception
   */
  public function getAuthProtocols(array &$protocols): void
  {
    $this->call([MoUnoOAuth20::class, 'getProtocol'], ['protocols' => &$protocols]);
    $this->call([MoStandardReadProtocols::class, 'getAuthProtocols'], ['protocols' => &$protocols]);
  }

  public function gatherTokenFromIDP(MoClientConfiguration $client_config, ?string $code, array $query_params): array
  {
    return match ($client_config->getLoginProtocol()) {
      'OAuth' => $this->call(
        [MoUnoOAuth20::class, 'gatherTokenFromIDP'],
        [
          'client_config' => $client_config, 'code' => $code, 'query_params' => $query_params
        ],
      ),
      'OpenID' => $this->call(
        [MoStandardReadProtocols::class, 'gatherTokenFromIDP'],
        ['client_config' => $client_config, 'code' => $code, 'query_params' => $query_params]
      )
    };
  }

  public function gatherUserInfoFromIDP(MoClientConfiguration $client_config, array $token_data)
  {

    return match ($client_config->getLoginProtocol()) {
      'OAuth' => $this->call(
        [MoUnoOAuth20::class, 'gatherUserInfoFromIDP'],
        ['client_config' => $client_config, 'token_data' => $token_data]
      ),
      'OpenID' => $this->call(
        [MoStandardReadProtocols::class, 'gatherUserInfoFromIDP'],
        ['client_config' => $client_config, 'token_data' => $token_data]
      )
    };
  }
}
